/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.sound;

import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.FlatColorButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.SoundElementButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.SoundPackButton;
import com.github.tartaricacid.touhoulittlemaid.client.sound.CustomSoundLoader;
import com.github.tartaricacid.touhoulittlemaid.client.sound.data.MaidSoundInstance;
import com.github.tartaricacid.touhoulittlemaid.client.sound.pojo.SoundPackInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetMaidSoundIdMessage;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.mojang.blaze3d.audio.SoundBuffer;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class MaidSoundPackGui
extends Screen {
    private static final ResourceLocation ICON = new ResourceLocation("touhou_little_maid", "textures/gui/maid_custom_sound.png");
    private final int packPerSize = 4;
    private final int soundPerSize = 13;
    private final EntityMaid maid;
    private String selectSoundId = null;
    private int startX;
    private int startY;
    private int packPage = 0;
    private int soundPage = 0;
    private int packMaxPage = 0;
    private int soundMaxPage = 0;

    public MaidSoundPackGui(EntityMaid maid) {
        super((Component)Component.m_237113_((String)"Maid Custom Sound Pack GUI"));
        this.maid = maid;
    }

    protected void m_7856_() {
        this.m_169413_();
        this.startX = (this.f_96543_ - 400) / 2;
        this.startY = (this.f_96544_ - 220) / 2;
        this.packMaxPage = (CustomSoundLoader.CACHE.size() - 1) / 4;
        this.soundMaxPage = 0;
        this.addSoundPackButtons();
        this.addPackPageButtons();
        if (StringUtils.isNotBlank((CharSequence)this.selectSoundId) && CustomSoundLoader.CACHE.containsKey(this.selectSoundId)) {
            this.addSoundElementButtons();
            this.addSoundOtherButtons();
            this.addSoundElementPageButtons();
        }
    }

    private void addPackPageButtons() {
        this.m_142416_((GuiEventListener)new FlatColorButton(this.startX + 5, this.startY + 201, 32, 16, (Component)Component.m_237113_((String)"<"), b -> {
            if (this.packPage > 0) {
                --this.packPage;
                this.m_7856_();
            }
        }));
        this.m_142416_((GuiEventListener)new FlatColorButton(this.startX + 203, this.startY + 201, 32, 16, (Component)Component.m_237113_((String)">"), b -> {
            if ((this.packPage + 1) * 4 < CustomSoundLoader.CACHE.size()) {
                ++this.packPage;
                this.m_7856_();
            }
        }));
    }

    private void addSoundElementButtons() {
        int yOffset = 41;
        boolean otherColor = false;
        Map<ResourceLocation, List<SoundBuffer>> buffers = CustomSoundLoader.getSoundCache(this.selectSoundId).getBuffers();
        List<ResourceLocation> soundIds = List.copyOf(buffers.keySet());
        this.soundMaxPage = (buffers.size() - 1) / 13;
        int startSoundIndex = this.soundPage * 13;
        if (startSoundIndex >= soundIds.size()) {
            this.soundPage = 0;
            startSoundIndex = 0;
        }
        int endSoundIndex = Math.min(soundIds.size(), startSoundIndex + 13);
        for (int i = startSoundIndex; i < endSoundIndex; ++i) {
            ResourceLocation soundEvent = soundIds.get(i);
            this.m_142416_((GuiEventListener)new SoundElementButton(this.startX + 245, this.startY + yOffset, 152, 12, soundEvent, buffers.get(soundEvent), otherColor, b -> {
                SoundElementButton soundButton = (SoundElementButton)b;
                SoundEvent event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundButton.getSoundEvent());
                if (this.f_96541_ != null && event != null) {
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)new MaidSoundInstance(event, this.selectSoundId, this.maid, true));
                }
            }).setTooltips("tooltips.touhou_little_maid.custom_sound.play_sound"));
            otherColor = !otherColor;
            yOffset += 12;
        }
    }

    private void addSoundOtherButtons() {
        this.m_142416_((GuiEventListener)new FlatColorButton(this.startX + 245, this.startY + 19, 110, 18, (Component)Component.m_237115_((String)"gui.touhou_little_maid.custom_sound.pack.apply"), b -> {
            if (StringUtils.isNotBlank((CharSequence)this.selectSoundId) && CustomSoundLoader.CACHE.containsKey(this.selectSoundId)) {
                this.maid.setSoundPackId(this.selectSoundId);
                NetworkHandler.CHANNEL.sendToServer((Object)new SetMaidSoundIdMessage(this.maid.m_19879_(), this.selectSoundId));
                this.m_7856_();
            }
        }));
        this.m_142416_((GuiEventListener)new FlatColorButton(this.startX + 358, this.startY + 19, 18, 18, (Component)Component.m_237119_(), b -> {
            String url;
            if (StringUtils.isNotBlank((CharSequence)this.selectSoundId) && CustomSoundLoader.CACHE.containsKey(this.selectSoundId) && StringUtils.isNotBlank((CharSequence)(url = CustomSoundLoader.getSoundCache(this.selectSoundId).getInfo().getUrl())) && this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new ConfirmLinkScreen(yes -> {
                    if (yes) {
                        Util.m_137581_().m_137646_(url);
                    }
                    this.f_96541_.m_91152_((Screen)this);
                }, url, false));
            }
        }).setTooltips("tooltips.touhou_little_maid.custom_sound.open_url"));
        this.m_142416_((GuiEventListener)new FlatColorButton(this.startX + 379, this.startY + 19, 18, 18, (Component)Component.m_237119_(), b -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91106_().m_120367_((SoundInstance)new MaidSoundInstance((SoundEvent)InitSounds.MAID_CREDIT.get(), this.selectSoundId, this.maid, true));
            }
        }).setTooltips("tooltips.touhou_little_maid.custom_sound.credit"));
    }

    private void addSoundElementPageButtons() {
        this.m_142416_((GuiEventListener)new FlatColorButton(this.startX + 245, this.startY + 201, 16, 16, (Component)Component.m_237113_((String)"<"), b -> {
            if (this.soundPage > 0) {
                --this.soundPage;
                this.m_7856_();
            }
        }));
        this.m_142416_((GuiEventListener)new FlatColorButton(this.startX + 381, this.startY + 201, 16, 16, (Component)Component.m_237113_((String)">"), b -> {
            Map<ResourceLocation, List<SoundBuffer>> buffersIn;
            if (StringUtils.isNotBlank((CharSequence)this.selectSoundId) && CustomSoundLoader.CACHE.containsKey(this.selectSoundId) && (this.soundPage + 1) * 13 < (buffersIn = CustomSoundLoader.getSoundCache(this.selectSoundId).getBuffers()).size()) {
                ++this.soundPage;
                this.m_7856_();
            }
        }));
    }

    private void addSoundPackButtons() {
        int yOffset = 19;
        int startPackIndex = this.packPage * 4;
        ArrayList<String> soundPackIds = new ArrayList<String>(CustomSoundLoader.CACHE.keySet());
        if (startPackIndex >= soundPackIds.size()) {
            this.packPage = 0;
            startPackIndex = 0;
        }
        int endPackIndex = Math.min(soundPackIds.size(), startPackIndex + 4);
        for (int i = startPackIndex; i < endPackIndex; ++i) {
            String soundId = (String)soundPackIds.get(i);
            SoundPackInfo info = CustomSoundLoader.getSoundCache(soundId).getInfo();
            SoundPackButton button = new SoundPackButton(this.startX + 5, this.startY + yOffset, info, b -> {
                this.selectSoundId = soundId;
                this.soundPage = 0;
                this.m_7856_();
            });
            if (StringUtils.isNotBlank((CharSequence)info.getDescription())) {
                MutableComponent description = ParseI18n.parse(info.getDescription());
                button.setTooltips(Collections.singletonList(description));
            }
            if (soundId.equals(this.selectSoundId)) {
                button.setSelect(true);
            }
            if (soundId.equals(this.maid.getSoundPackId())) {
                button.setUse(true);
            }
            this.m_142416_((GuiEventListener)button);
            yOffset += 45;
        }
    }

    public void m_88315_(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(graphics);
        graphics.m_280509_(this.startX, this.startY, this.startX + 240, this.startY + 220, -14013910);
        graphics.m_280509_(this.startX + 242, this.startY, this.startX + 400, this.startY + 220, -14013910);
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.touhou_little_maid.custom_sound.pack.title"), this.startX + 120, this.startY + 6, 0xFFFFFF);
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.touhou_little_maid.custom_sound.sounds.preview"), this.startX + 321, this.startY + 6, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, String.format("%d/%d", this.packPage + 1, this.packMaxPage + 1), this.startX + 120, this.startY + 206, 0xBBBBBB);
        super.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
        if (StringUtils.isNotBlank((CharSequence)this.selectSoundId) && CustomSoundLoader.CACHE.containsKey(this.selectSoundId)) {
            graphics.m_280137_(this.f_96547_, String.format("%d/%d", this.soundPage + 1, this.soundMaxPage + 1), this.startX + 321, this.startY + 206, 0xBBBBBB);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICON);
            graphics.m_280163_(ICON, this.startX + 359, this.startY + 20, 0.0f, 0.0f, 16, 16, 256, 256);
            graphics.m_280163_(ICON, this.startX + 380, this.startY + 20, 16.0f, 0.0f, 16, 16, 256, 256);
        }
        this.f_169369_.stream().filter(b -> b instanceof FlatColorButton).forEach(b -> ((FlatColorButton)((Object)b)).renderToolTip(graphics, this, pMouseX, pMouseY));
    }
}

