/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.item;

import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.FlatColorButton;
import com.github.tartaricacid.touhoulittlemaid.entity.misc.DefaultMonsterType;
import com.github.tartaricacid.touhoulittlemaid.entity.misc.MonsterType;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetMonsterListMessage;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class MonsterListScreen
extends Screen {
    private static final int PER_MAX_COUNT = 10;
    private final Map<EntityType<?>, MonsterType> monsterList;
    private final List<EntityType<?>> monsterListIndex;
    private int page = 0;
    private int posX;
    private int posY;

    public MonsterListScreen(ItemStack stack) {
        super((Component)Component.m_237113_((String)"Monster List Screen"));
        this.monsterList = DefaultMonsterType.getMonsterList(stack, (Level)Minecraft.m_91087_().f_91073_);
        this.monsterListIndex = this.monsterList.keySet().stream().toList();
    }

    protected void m_7856_() {
        int index;
        this.m_169413_();
        this.posX = this.f_96543_ / 2;
        this.posY = this.f_96544_ / 2;
        int startY = this.posY - 80 - 8;
        int size = this.monsterListIndex.size();
        for (int i = 0; i < 10 && (index = this.page * 10 + i) < size; ++i) {
            EntityType<?> entityType = this.monsterListIndex.get(index);
            MonsterType monsterType = this.monsterList.get(entityType);
            MutableComponent text = monsterType.getComponent().m_6881_().m_7220_(CommonComponents.f_263701_).m_7220_(entityType.m_20676_());
            FlatColorButton button = new FlatColorButton(this.posX - 100, startY, 200, 14, (Component)text, b -> {
                MonsterType next = monsterType.getNext();
                this.monsterList.put(entityType, next);
                this.m_7856_();
            });
            this.m_142416_((GuiEventListener)button);
            startY += 16;
        }
        startY = this.posY + 80 - 8;
        this.m_142416_((GuiEventListener)new FlatColorButton(this.posX - 100, startY, 28, 14, (Component)Component.m_237113_((String)"<"), b -> {
            if (this.page > 0) {
                --this.page;
                this.m_7856_();
            }
        }));
        this.m_142416_((GuiEventListener)new FlatColorButton(this.posX + 100 - 28, startY, 28, 14, (Component)Component.m_237113_((String)">"), b -> {
            int nextStartIndex = (this.page + 1) * 10;
            if (nextStartIndex < this.monsterListIndex.size()) {
                ++this.page;
                this.m_7856_();
            }
        }));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        String pageText = String.format("%d/%d", this.page + 1, this.monsterListIndex.size() / 10 + 1);
        int startY = this.posY + 80 - 5;
        graphics.m_280137_(this.f_96547_, pageText, this.posX, startY, 0xFFFFFF);
    }

    public void m_7379_() {
        HashMap monsterListOutput = Maps.newHashMap();
        this.monsterList.forEach((type, monsterType) -> {
            ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey(type);
            monsterListOutput.put(key, monsterType);
        });
        NetworkHandler.CHANNEL.sendToServer((Object)new SetMonsterListMessage(monsterListOutput));
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }
}

