/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class ConditionalVehicle {
    private static final String EMPTY = "";
    private final List<ResourceLocation> idTest = Lists.newArrayList();
    private final List<TagKey<EntityType<?>>> tagTest = Lists.newArrayList();
    private final String idPre;
    private final String tagPre;

    public ConditionalVehicle() {
        this.idPre = "vehicle$";
        this.tagPre = "vehicle#";
    }

    public void addTest(String name) {
        int preSize = this.idPre.length();
        if (name.length() <= preSize) {
            return;
        }
        String substring = name.substring(preSize);
        if (name.startsWith(this.idPre) && ResourceLocation.m_135830_((String)substring)) {
            this.idTest.add(new ResourceLocation(substring));
        }
        if (name.startsWith(this.tagPre) && ResourceLocation.m_135830_((String)substring)) {
            ITagManager tags = ForgeRegistries.ENTITY_TYPES.tags();
            if (tags == null) {
                return;
            }
            TagKey tagKey = tags.createTagKey(new ResourceLocation(substring));
            this.tagTest.add(tagKey);
        }
    }

    public String doTest(Mob maid) {
        Entity vehicle = maid.m_20202_();
        if (vehicle == null || !vehicle.m_6084_()) {
            return EMPTY;
        }
        String result = this.doIdTest(vehicle);
        if (result.isEmpty()) {
            return this.doTagTest(vehicle);
        }
        return result;
    }

    private String doIdTest(Entity vehicle) {
        if (this.idTest.isEmpty()) {
            return EMPTY;
        }
        ResourceLocation registryName = ForgeRegistries.ENTITY_TYPES.getKey((Object)vehicle.m_6095_());
        if (registryName == null) {
            return EMPTY;
        }
        if (this.idTest.contains(registryName)) {
            return this.idPre + registryName;
        }
        return EMPTY;
    }

    private String doTagTest(Entity vehicle) {
        if (this.tagTest.isEmpty()) {
            return EMPTY;
        }
        ITagManager tags = ForgeRegistries.ENTITY_TYPES.tags();
        if (tags == null) {
            return EMPTY;
        }
        return this.tagTest.stream().filter(tag -> vehicle.m_6095_().m_204039_(tag)).findFirst().map(itemTagKey -> this.tagPre + itemTagKey.f_203868_()).orElse(EMPTY);
    }
}

