/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.misc.DefaultMonsterType;
import com.github.tartaricacid.touhoulittlemaid.entity.misc.MonsterType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemMonsterList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public interface IAttackTask
extends IMaidTask {
    public static Optional<? extends LivingEntity> findFirstValidAttackTarget(EntityMaid maid) {
        return maid.m_6274_().m_21952_(MemoryModuleType.f_148205_).flatMap(mobs -> mobs.m_186116_(e -> maid.m_6779_((LivingEntity)e) && maid.m_21444_(e.m_20183_())));
    }

    default public boolean canAttack(EntityMaid maid, LivingEntity target) {
        CompoundTag monsterList;
        TamableAnimal tamableAnimal;
        ResourceLocation location = ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_());
        if (location == null) {
            return false;
        }
        String id = location.toString();
        if (target instanceof Player) {
            return false;
        }
        if (target instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)target).m_21805_() != null) {
            return false;
        }
        if (((List)MaidConfig.MAID_ATTACK_IGNORE.get()).contains(id)) {
            return false;
        }
        ItemStack offhandItem = maid.m_21206_();
        if (offhandItem.m_150930_((Item)InitItems.MONSTER_LIST.get()) && (monsterList = ItemMonsterList.getMonsterList(offhandItem)).m_128425_(id, 3)) {
            int index = monsterList.m_128451_(id);
            MonsterType monsterType = MonsterType.getTypeByIndex(index);
            return DefaultMonsterType.canAttack(maid, target, monsterType);
        }
        MonsterType monsterType = DefaultMonsterType.getMonsterType(target.m_6095_());
        return DefaultMonsterType.canAttack(maid, target, monsterType);
    }

    default public boolean hasExtraAttack(EntityMaid maid, Entity target) {
        return false;
    }

    default public boolean doExtraAttack(EntityMaid maid, Entity target) {
        return false;
    }
}

