/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.entity;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.IMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.api.event.ConvertMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.BackpackManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.github.tartaricacid.touhoulittlemaid.util.BiomeCacheUtil;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public interface IMaid {
    @Nullable
    public static IMaid convert(Mob mob) {
        if (mob instanceof IMaid) {
            IMaid maid = (IMaid)mob;
            return maid;
        }
        ConvertMaidEvent event = new ConvertMaidEvent(mob);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getMaid();
    }

    @Nullable
    public static EntityMaid convertToMaid(Mob mob) {
        IMaid convert = IMaid.convert(mob);
        if (convert == null) {
            return null;
        }
        return convert.asStrictMaid();
    }

    @Nullable
    default public EntityMaid asStrictMaid() {
        return null;
    }

    public String getModelId();

    public Mob asEntity();

    default public ItemStack[] getHandItemsForAnimation() {
        return new ItemStack[]{ItemStack.f_41583_, ItemStack.f_41583_};
    }

    default public IMaidTask getTask() {
        return TaskManager.getIdleTask();
    }

    default public boolean isSwingingArms() {
        return false;
    }

    default public int getExperience() {
        return 0;
    }

    default public boolean isMaidInSittingPose() {
        return false;
    }

    default public boolean isBegging() {
        return false;
    }

    default public int getFavorability() {
        return 0;
    }

    default public ItemStack getBackpackShowItem() {
        return ItemStack.f_41583_;
    }

    default public IMaidBackpack getMaidBackpackType() {
        return BackpackManager.getEmptyBackpack();
    }

    default public boolean hasBackpack() {
        return this.getMaidBackpackType() != BackpackManager.getEmptyBackpack();
    }

    default public boolean hasHelmet() {
        return !this.asEntity().m_6844_(EquipmentSlot.HEAD).m_41619_();
    }

    default public boolean hasChestPlate() {
        return !this.asEntity().m_6844_(EquipmentSlot.CHEST).m_41619_();
    }

    default public boolean hasLeggings() {
        return !this.asEntity().m_6844_(EquipmentSlot.LEGS).m_41619_();
    }

    default public boolean hasBoots() {
        return !this.asEntity().m_6844_(EquipmentSlot.FEET).m_41619_();
    }

    default public boolean onHurt() {
        return this.asEntity().f_20916_ > 0;
    }

    @Deprecated
    default public String getAtBiomeTemp() {
        float temp = BiomeCacheUtil.getCacheBiome((Entity)this.asEntity()).m_47554_();
        if ((double)temp < 0.15) {
            return "COLD";
        }
        if ((double)temp < 0.55) {
            return "OCEAN";
        }
        if ((double)temp < 0.95) {
            return "MEDIUM";
        }
        return "WARM";
    }

    @Deprecated
    default public boolean hasSasimono() {
        return false;
    }

    @Deprecated
    default public boolean isSitInJoyBlock() {
        return false;
    }

    @Deprecated
    default public int getDim() {
        ResourceKey dim = this.asEntity().f_19853_.m_46472_();
        if (dim.equals((Object)Level.f_46428_)) {
            return 0;
        }
        if (dim.equals((Object)Level.f_46429_)) {
            return -1;
        }
        if (dim.equals((Object)Level.f_46430_)) {
            return 1;
        }
        return 0;
    }
}

