/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.teamlapen.werewolves.util.AlphanumericComparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public abstract class WerewolfBaseModel<T extends LivingEntity>
extends PlayerModel<T> {
    protected PlayerModel<T> playerModel;

    public static MeshDefinition createMesh(CubeDeformation deformation) {
        return PlayerModel.m_170825_((CubeDeformation)deformation, (boolean)false);
    }

    public WerewolfBaseModel(ModelPart part) {
        super(part, false);
    }

    protected float m_102835_(float p_205060_1_, float p_205060_2_, float p_205060_3_) {
        float f = (p_205060_2_ - p_205060_1_) % ((float)Math.PI * 2);
        if (f < (float)(-Math.PI)) {
            f += (float)Math.PI * 2;
        }
        if (f >= (float)Math.PI) {
            f -= (float)Math.PI * 2;
        }
        return p_205060_1_ + p_205060_3_ * f;
    }

    @Nullable
    public abstract ModelPart getModelRenderer();

    @Nullable
    public abstract ModelPart getHeadModel();

    @Nullable
    public abstract ModelPart getLeftArmModel();

    @Nullable
    public abstract ModelPart getRightArmModel();

    public void setPlayerModel(PlayerModel<T> model) {
        this.playerModel = model;
    }

    @Nonnull
    protected abstract Iterable<ModelPart> m_5608_();

    @Deprecated
    public void m_103401_(@Nonnull PoseStack stack, @Nonnull VertexConsumer builder, int p_228287_3_, int p_228287_4_) {
    }

    @Deprecated
    public void m_103411_(@Nonnull PoseStack stack, @Nonnull VertexConsumer builder, int p_228289_3_, int p_228289_4_) {
    }

    public void m_6973_(@Nonnull T p_225597_1_, float p_225597_2_, float p_225597_3_, float p_225597_4_, float p_225597_5_, float p_225597_6_) {
    }

    public void m_8009_(boolean p_178719_1_) {
    }

    public void m_6002_(@Nonnull HumanoidArm arm, @Nonnull PoseStack stack) {
    }

    protected static List<ResourceLocation> getTextures(String texturePath) {
        return Minecraft.m_91087_().m_91098_().m_214159_(texturePath, s -> s.m_135815_().endsWith(".png")).keySet().stream().sorted(new AlphanumericComparator()).filter(r -> "werewolves".equals(r.m_135827_())).collect(Collectors.toList());
    }

    protected HumanoidArm m_102856_(T pEntity) {
        HumanoidArm humanoidarm = pEntity.m_5737_();
        return ((LivingEntity)pEntity).f_20912_ == InteractionHand.MAIN_HAND ? humanoidarm : humanoidarm.m_20828_();
    }

    @NotNull
    protected abstract ModelPart m_102851_(@NotNull HumanoidArm var1);
}

