/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.data.recipe;

import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModTags;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.grid.vampiresdelight.common.registry.VDItems;
import net.grid.vampiresdelight.common.tag.VDForgeTags;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.client.recipebook.CookingPotRecipeBookTab;
import vectorwing.farmersdelight.common.tag.ForgeTags;
import vectorwing.farmersdelight.data.builder.CookingPotRecipeBuilder;

public class VDCookingRecipes {
    public static final int FAST_COOKING = 100;
    public static final int NORMAL_COOKING = 200;
    public static final int SLOW_FERMENTING = 1200;
    public static final float SMALL_EXP = 0.35f;
    public static final float MEDIUM_EXP = 1.0f;
    public static final float LARGE_EXP = 2.0f;

    public static void register(Consumer<FinishedRecipe> consumer) {
        VDCookingRecipes.cookMiscellaneous(consumer);
        VDCookingRecipes.cookMeals(consumer);
        VDCookingRecipes.fermentingAlternatives(consumer);
    }

    private static void cookMiscellaneous(Consumer<FinishedRecipe> consumer) {
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)VDItems.DAISY_TEA.get()), (int)1, (int)200, (float)1.0f).addIngredient((ItemLike)Items.f_41948_).addIngredient((ItemLike)Items.f_41948_).unlockedByItems("has_oxeye_daisy", new ItemLike[]{Items.f_41948_}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).build(consumer, VDCookingRecipes.itemLocationCooking((Item)VDItems.DAISY_TEA.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)VDItems.ORCHID_TEA.get()), (int)1, (int)200, (float)1.0f).addIngredient(ForgeTags.MILK).addIngredient((ItemLike)VDItems.ORCHID_PETALS.get()).addIngredient((ItemLike)VDItems.ORCHID_PETALS.get()).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)VDItems.ORCHID_PETALS.get(), (ItemLike)ModBlocks.VAMPIRE_ORCHID.get()}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).build(consumer, VDCookingRecipes.itemLocationCooking((Item)VDItems.ORCHID_TEA.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)VDItems.WEIRD_JELLY_BLOCK.get()), (int)1, (int)200, (float)1.0f).addIngredient((ItemLike)Items.f_42500_).addIngredient((ItemLike)Items.f_42518_).addIngredient((ItemLike)Items.f_42518_).addIngredient((ItemLike)Items.f_42780_).addIngredient((ItemLike)Items.f_42780_).addIngredient(ModTags.Items.PURE_BLOOD).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.PURE_BLOOD_0.get(), (ItemLike)ModItems.PURE_BLOOD_1.get(), (ItemLike)ModItems.PURE_BLOOD_2.get(), (ItemLike)ModItems.PURE_BLOOD_3.get(), (ItemLike)ModItems.PURE_BLOOD_4.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer, VDCookingRecipes.itemLocationCooking((Item)VDItems.WEIRD_JELLY_BLOCK.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)VDItems.TRICOLOR_DANGO.get()), (int)1, (int)200, (float)1.0f, (ItemLike)Items.f_42398_).addIngredient(VDForgeTags.DOUGH_RICE).addIngredient((ItemLike)VDItems.BLOOD_SYRUP.get()).addIngredient((ItemLike)VDItems.ORCHID_PETALS.get()).addIngredient((ItemLike)Items.f_42501_).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)VDItems.ORCHID_PETALS.get(), (ItemLike)VDItems.BLOOD_SYRUP.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).build(consumer, VDCookingRecipes.itemLocationCooking((Item)VDItems.TRICOLOR_DANGO.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)VDItems.MULLED_WINE_GLASS.get()), (int)1, (int)200, (float)1.0f).addIngredient((ItemLike)VDItems.BLOOD_WINE_GLASS.get()).addIngredient(Ingredient.m_43938_(Stream.of(new Ingredient.ItemValue(new ItemStack((ItemLike)ModBlocks.CURSED_ROOTS.get())), new Ingredient.ItemValue(new ItemStack((ItemLike)ModBlocks.CURSED_SPRUCE_SAPLING.get())), new Ingredient.ItemValue(new ItemStack((ItemLike)ModBlocks.DARK_SPRUCE_SAPLING.get())), new Ingredient.ItemValue(new ItemStack((ItemLike)ModBlocks.DARK_SPRUCE_LEAVES.get()))))).addIngredient((ItemLike)Items.f_42501_).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)VDItems.BLOOD_WINE_GLASS.get()}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).build(consumer, VDCookingRecipes.itemLocationCooking((Item)VDItems.MULLED_WINE_GLASS.get()));
    }

    private static void cookMeals(Consumer<FinishedRecipe> consumer) {
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)VDItems.ORCHID_CREAM_SOUP.get()), (int)1, (int)200, (float)1.0f).addIngredient((ItemLike)VDItems.ORCHID_PETALS.get()).addIngredient(ForgeTags.SALAD_INGREDIENTS).addIngredient(ForgeTags.VEGETABLES_ONION).addIngredient((ItemLike)Items.f_42620_).addIngredient(ForgeTags.MILK).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)VDItems.ORCHID_PETALS.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer, VDCookingRecipes.itemLocationCooking((Item)VDItems.ORCHID_CREAM_SOUP.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)VDItems.BLACK_MUSHROOM_SOUP.get()), (int)1, (int)200, (float)1.0f).addIngredient((ItemLike)VDItems.BLACK_MUSHROOM.get()).addIngredient((ItemLike)Items.f_42620_).addIngredient((ItemLike)Items.f_42619_).addIngredient(ForgeTags.VEGETABLES_ONION).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)VDItems.BLACK_MUSHROOM.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer, VDCookingRecipes.itemLocationCooking((Item)VDItems.BLACK_MUSHROOM_SOUP.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)VDItems.ORCHID_CURRY.get()), (int)1, (int)200, (float)1.0f).addIngredient((ItemLike)VDItems.ORCHID_PETALS.get()).addIngredient((ItemLike)VDItems.ORCHID_PETALS.get()).addIngredient((ItemLike)Items.f_42620_).addIngredient(ForgeTags.VEGETABLES_ONION).addIngredient(Ingredient.m_43938_(Stream.of(new Ingredient.TagValue(ForgeTags.RAW_MUTTON), new Ingredient.TagValue(ForgeTags.RAW_BEEF)))).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)VDItems.ORCHID_PETALS.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer, VDCookingRecipes.itemLocationCooking((Item)VDItems.ORCHID_CURRY.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)VDItems.BLACK_MUSHROOM_NOODLES.get()), (int)1, (int)200, (float)1.0f).addIngredient((ItemLike)VDItems.BLACK_MUSHROOM.get()).addIngredient((ItemLike)VDItems.BLACK_MUSHROOM.get()).addIngredient(ForgeTags.PASTA).addIngredient(ForgeTags.VEGETABLES_ONION).addIngredient(ForgeTags.MILK).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)VDItems.BLACK_MUSHROOM.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer, VDCookingRecipes.itemLocationCooking((Item)VDItems.BLACK_MUSHROOM_NOODLES.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)VDItems.GARLIC_SOUP.get()), (int)1, (int)200, (float)1.0f, (ItemLike)Items.f_42406_).addIngredient(ForgeTags.RAW_CHICKEN).addIngredient(VDForgeTags.VEGETABLES_GARLIC).addIngredient(ForgeTags.VEGETABLES).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)VDItems.GRILLED_GARLIC.get(), (ItemLike)ModItems.ITEM_GARLIC.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer, VDCookingRecipes.itemLocationCooking((Item)VDItems.GARLIC_SOUP.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)VDItems.BORSCHT.get()), (int)1, (int)200, (float)1.0f).addIngredient(Ingredient.m_43938_(Stream.of(new Ingredient.TagValue(ForgeTags.RAW_PORK), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_42579_)), new Ingredient.TagValue(ForgeTags.RAW_CHICKEN)))).addIngredient(Ingredient.m_43938_(Stream.of(new Ingredient.TagValue(ForgeTags.VEGETABLES_POTATO), new Ingredient.TagValue(ForgeTags.VEGETABLES_CARROT)))).addIngredient(ForgeTags.VEGETABLES_BEETROOT).addIngredient(VDForgeTags.VEGETABLES_GARLIC).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)VDItems.GRILLED_GARLIC.get(), (ItemLike)ModItems.ITEM_GARLIC.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer, VDCookingRecipes.itemLocationCooking((Item)VDItems.BORSCHT.get()));
    }

    private static void fermentingAlternatives(Consumer<FinishedRecipe> consumer) {
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)VDItems.DANDELION_BEER_BOTTLE.get()), (int)1, (int)1200, (float)2.0f, (ItemLike)Items.f_42590_).addIngredient((ItemLike)Items.f_42405_).addIngredient((ItemLike)Items.f_42405_).addIngredient((ItemLike)Items.f_42405_).addIngredient((ItemLike)Items.f_41939_).addIngredient((ItemLike)Items.f_42501_).unlockedByAnyIngredient(new ItemLike[]{Items.f_42405_, Items.f_41939_}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).build(consumer, VDCookingRecipes.itemLocationCooking((Item)VDItems.DANDELION_BEER_BOTTLE.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)VDItems.BLOOD_WINE_BOTTLE.get()), (int)1, (int)1200, (float)2.0f, (ItemLike)Items.f_42590_).addIngredient((ItemLike)VDItems.BLOOD_SYRUP.get()).addIngredient((ItemLike)VDItems.BLOOD_SYRUP.get()).addIngredient((ItemLike)VDItems.BLOOD_SYRUP.get()).addIngredient((ItemLike)Items.f_42780_).addIngredient((ItemLike)Items.f_42501_).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)VDItems.BLOOD_SYRUP.get()}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).build(consumer, VDCookingRecipes.itemLocationCooking((Item)VDItems.BLOOD_WINE_BOTTLE.get()));
    }

    private static ResourceLocation itemLocationCooking(Item item) {
        return new ResourceLocation("vampiresdelight:cooking/" + ForgeRegistries.ITEMS.getKey((Object)item).m_135815_());
    }

    private static ResourceLocation blockLocationCooking(Block block) {
        return new ResourceLocation("vampiresdelight:cooking/" + ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_());
    }
}

