/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.data;

import java.util.Map;
import java.util.function.Function;
import net.grid.vampiresdelight.common.block.BarStoolBlock;
import net.grid.vampiresdelight.common.block.ConsumableCakeBlock;
import net.grid.vampiresdelight.common.block.ConsumableCandleCakeBlock;
import net.grid.vampiresdelight.common.block.DarkStoneStoveBlock;
import net.grid.vampiresdelight.common.block.VampireOrchidCropBlock;
import net.grid.vampiresdelight.common.block.WineShelfBlock;
import net.grid.vampiresdelight.common.registry.VDBlocks;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.block.CabinetBlock;
import vectorwing.farmersdelight.common.block.FeastBlock;
import vectorwing.farmersdelight.common.block.PieBlock;

public class VDBlockStates
extends BlockStateProvider {
    private static final int DEFAULT_ANGLE_OFFSET = 180;

    public VDBlockStates(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "vampiresdelight", existingFileHelper);
    }

    public String blockName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("vampiresdelight", "block/" + path);
    }

    public ModelFile existingModel(Block block) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(this.blockName(block)), this.models().existingFileHelper);
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)VDBlocks.BLOODY_SOIL.get(), this.cubeRandomRotation((Block)VDBlocks.BLOODY_SOIL.get(), ""));
        this.cabinetBlock((Block)VDBlocks.DARK_SPRUCE_CABINET.get(), "dark_spruce");
        this.cabinetBlock((Block)VDBlocks.CURSED_SPRUCE_CABINET.get(), "cursed_spruce");
        this.cabinetBlock((Block)VDBlocks.JACARANDA_CABINET.get(), "jacaranda");
        this.cabinetBlock((Block)VDBlocks.MAGIC_CABINET.get(), "magic");
        this.wildCropBlock((Block)VDBlocks.WILD_GARLIC.get());
        this.horizontalBlock((Block)VDBlocks.DARK_STONE_STOVE.get(), state -> {
            String name = this.blockName((Block)VDBlocks.DARK_STONE_STOVE.get());
            String suffix = (Boolean)state.m_61143_((Property)DarkStoneStoveBlock.LIT) != false ? "_on" : "";
            return this.models().orientableWithBottom(name + suffix, this.resourceBlock(name + "_side"), this.resourceBlock(name + "_front" + suffix), this.resourceBlock(name + "_bottom"), this.resourceBlock(name + "_top" + suffix));
        });
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)VDBlocks.VAMPIRE_ORCHID_CROP.get()).partialState().with((Property)VampireOrchidCropBlock.AGE, (Comparable)Integer.valueOf(0)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("vampire_orchid_crop_stage0"))).addModel()).partialState().with((Property)VampireOrchidCropBlock.AGE, (Comparable)Integer.valueOf(1)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("vampire_orchid_crop_stage1"))).addModel();
        this.feastBlock((FeastBlock)VDBlocks.WEIRD_JELLY_BLOCK.get());
        this.simpleBlock((Block)VDBlocks.BLOOD_WINE_BOTTLE_PLACED.get(), this.existingModel((Block)VDBlocks.BLOOD_WINE_BOTTLE_PLACED.get()));
        this.simpleBlock((Block)VDBlocks.DANDELION_BEER_BOTTLE_PLACED.get(), this.existingModel((Block)VDBlocks.DANDELION_BEER_BOTTLE_PLACED.get()));
        this.crateBlock((Block)VDBlocks.GARLIC_CRATE.get(), "garlic");
        this.bagBlock((Block)VDBlocks.ORCHID_BAG.get());
        this.pieBlock((Block)VDBlocks.BLOOD_PIE.get());
        this.hugeBlackMushroomBlock((Block)VDBlocks.BLACK_MUSHROOM_BLOCK.get());
        this.hugeBlackMushroomBlock((Block)VDBlocks.BLACK_MUSHROOM_STEM.get());
        this.plantBlock((Block)VDBlocks.BLACK_MUSHROOM.get());
        this.pottedPlantBlock((Block)VDBlocks.POTTED_BLACK_MUSHROOM.get(), (Block)VDBlocks.BLACK_MUSHROOM.get());
        this.farmlandBlock((Block)VDBlocks.CURSED_FARMLAND.get());
        this.farmlandBlock((Block)VDBlocks.BLOODY_SOIL_FARMLAND.get());
        WineShelfBlock.getAllShelveBlocks().forEach(this::wineShelfBlock);
        BarStoolBlock.getBarStoolBlocks().forEach(block -> this.simpleBlock((Block)block, this.existingModel((Block)block)));
        ConsumableCandleCakeBlock.getAllCandleCakes().forEach(block -> this.candleCakeBlock((ConsumableCandleCakeBlock)((Object)block)));
        this.cakeBlock((Block)VDBlocks.ORCHID_CAKE.get());
    }

    public ConfiguredModel[] cubeRandomRotation(Block block, String suffix) {
        String formattedName = this.blockName(block) + (String)(suffix.isEmpty() ? "" : "_" + suffix);
        return ConfiguredModel.allYRotations((ModelFile)this.models().cubeAll(formattedName, this.resourceBlock(formattedName)), (int)0, (boolean)false);
    }

    public void wildCropBlock(Block block) {
        this.wildCropBlock(block, false);
    }

    public void wildCropBlock(Block block, boolean isBushCrop) {
        if (isBushCrop) {
            this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().singleTexture(this.blockName(block), this.resourceBlock("bush_crop"), "crop", this.resourceBlock(this.blockName(block)))).renderType("cutout"));
        } else {
            this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(this.blockName(block), this.resourceBlock(this.blockName(block)))).renderType("cutout"));
        }
    }

    public void crateBlock(Block block, String cropName) {
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(this.blockName(block), this.resourceBlock(cropName + "_crate_side"), new ResourceLocation("farmersdelight", "block/crate_bottom"), this.resourceBlock(cropName + "_crate_top")));
    }

    public void bagBlock(Block block) {
        String name = this.blockName(block);
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "cube")).texture("particle", this.resourceBlock(name + "_top"))).texture("down", this.resourceBlock(name + "_bottom"))).texture("up", this.resourceBlock(name + "_top"))).texture("north", this.resourceBlock(name + "_side_tied"))).texture("south", this.resourceBlock(name + "_side_tied"))).texture("east", this.resourceBlock(name + "_side"))).texture("west", this.resourceBlock(name + "_side")));
    }

    public void plantBlock(Block block) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(this.blockName(block), this.resourceBlock(this.blockName(block)))).renderType("cutout"));
    }

    public void pottedPlantBlock(Block pottedBlock, Block plantBlock) {
        this.simpleBlock(pottedBlock, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.blockName(pottedBlock), "minecraft:block/flower_pot_cross")).texture("plant", this.resourceBlock(this.blockName(plantBlock)))).renderType("cutout"));
    }

    public void cabinetBlock(Block block, String woodType) {
        this.horizontalBlock(block, state -> {
            String suffix = (Boolean)state.m_61143_((Property)CabinetBlock.OPEN) != false ? "_open" : "";
            return this.models().orientable(this.blockName(block) + suffix, this.resourceBlock(woodType + "_cabinet_side"), this.resourceBlock(woodType + "_cabinet_front" + suffix), this.resourceBlock(woodType + "_cabinet_top"));
        });
    }

    public void feastBlock(FeastBlock block) {
        this.getVariantBuilder((Block)block).forAllStates(state -> {
            IntegerProperty servingsProperty = block.getServingsProperty();
            int servings = (Integer)state.m_61143_((Property)servingsProperty);
            Object suffix = "_stage" + (block.getMaxServings() - servings);
            if (servings == 0) {
                suffix = block.hasLeftovers ? "_leftover" : "_stage" + (servingsProperty.m_6908_().toArray().length - 2);
            }
            return ConfiguredModel.builder().modelFile(this.existingModel(this.blockName((Block)block) + (String)suffix)).rotationY(((int)((Direction)state.m_61143_((Property)FeastBlock.FACING)).m_122435_() + 180) % 360).build();
        });
    }

    public void pieBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int bites = (Integer)state.m_61143_((Property)PieBlock.BITES);
            Object suffix = bites > 0 ? "_slice" + bites : "";
            return ConfiguredModel.builder().modelFile(this.existingModel(this.blockName(block) + (String)suffix)).rotationY(((int)((Direction)state.m_61143_((Property)PieBlock.FACING)).m_122435_() + 180) % 360).build();
        });
    }

    public void hugeBlackMushroomBlock(Block block) {
        for (boolean boolValue : new boolean[]{true, false}) {
            for (Map.Entry entry : PipeBlock.f_55154_.entrySet()) {
                int xRot = 0;
                int yRot = 0;
                switch ((Direction)entry.getKey()) {
                    case EAST: {
                        yRot = 90;
                        break;
                    }
                    case SOUTH: {
                        yRot = 180;
                        break;
                    }
                    case WEST: {
                        yRot = 270;
                        break;
                    }
                    case UP: {
                        xRot = 270;
                        break;
                    }
                    case DOWN: {
                        xRot = 90;
                        break;
                    }
                }
                ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile(boolValue ? this.existingModel(this.blockName(block)) : this.existingModel("black_mushroom_block_inside")).rotationX(xRot).rotationY(yRot).uvLock(boolValue).addModel()).condition((Property)entry.getValue(), (Comparable[])new Boolean[]{boolValue}).end();
            }
        }
    }

    public void farmlandBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(blockState -> {
            int moisture = (Integer)blockState.m_61143_((Property)BlockStateProperties.f_61423_);
            String suffix = moisture >= 7 ? "_moist" : "";
            return ConfiguredModel.builder().modelFile(this.existingModel(this.blockName(block) + suffix)).build();
        });
    }

    public void cakeBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(blockState -> {
            int bites = (Integer)blockState.m_61143_((Property)ConsumableCakeBlock.f_51180_);
            Object suffix = bites > 0 ? "_slice" + bites : "";
            return ConfiguredModel.builder().modelFile(this.existingModel(this.blockName(block) + (String)suffix)).build();
        });
    }

    public void candleCakeBlock(ConsumableCandleCakeBlock block) {
        Block candle = block.getCandleBlock();
        ConsumableCakeBlock cake = block.getCakeBlock();
        ModelBuilder candleCake = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.blockName((Block)block), "block/template_cake_with_candle")).texture("candle", this.blockTexture(candle))).texture("bottom", this.withSuffix(this.blockTexture((Block)cake), "_bottom"))).texture("side", this.withSuffix(this.blockTexture((Block)cake), "_side"))).texture("top", this.withSuffix(this.blockTexture((Block)cake), "_top"))).texture("particle", this.withSuffix(this.blockTexture((Block)cake), "_side"));
        ModelBuilder candleCakeLit = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.blockName((Block)block) + "_lit", "block/template_cake_with_candle")).texture("candle", this.withSuffix(this.blockTexture(candle), "_lit"))).texture("bottom", this.withSuffix(this.blockTexture((Block)cake), "_bottom"))).texture("side", this.withSuffix(this.blockTexture((Block)cake), "_side"))).texture("top", this.withSuffix(this.blockTexture((Block)cake), "_top"))).texture("particle", this.withSuffix(this.blockTexture((Block)cake), "_side"));
        Function<BlockState, ModelFile> function = arg_0 -> VDBlockStates.lambda$candleCakeBlock$8((ModelFile)candleCakeLit, (ModelFile)candleCake, arg_0);
        this.getVariantBuilder((Block)block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)function.apply((BlockState)state)).build());
    }

    public void wineShelfBlock(Block block) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        int[] rotations = new int[]{270, 0, 90, 180};
        Direction[] directions = new Direction[]{Direction.WEST, Direction.NORTH, Direction.EAST, Direction.SOUTH};
        ModelFile baseModel = this.existingModel(this.blockName(block));
        ModelFile supportModel = this.existingModel(this.blockName(block) + "_support");
        for (int i = 0; i < rotations.length; ++i) {
            int rotation = rotations[i];
            Direction direction = directions[i];
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(baseModel).rotationY(rotation).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{direction}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(supportModel).rotationY(rotation).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{direction}).condition((Property)WineShelfBlock.HAS_UPPER_SUPPORT, (Comparable[])new Boolean[]{true}).end();
            this.wineShelfPart("blood_wine_bottle", WineShelfBlock.Slot.WINE_BOTTLE, builder, rotation, direction);
            this.wineShelfPart("dandelion_beer_bottle", WineShelfBlock.Slot.BEER_BOTTLE, builder, rotation, direction);
        }
    }

    private void wineShelfPart(String name, WineShelfBlock.Slot slot, MultiPartBlockStateBuilder builder, int rotation, Direction direction) {
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(this.existingModel(name + "_slot_top_left")).rotationY(rotation).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{direction}).condition(WineShelfBlock.WINE_SHELF_SLOT_0, (Comparable[])new WineShelfBlock.Slot[]{slot}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(this.existingModel(name + "_slot_top_right")).rotationY(rotation).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{direction}).condition(WineShelfBlock.WINE_SHELF_SLOT_1, (Comparable[])new WineShelfBlock.Slot[]{slot}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(this.existingModel(name + "_slot_bottom_left")).rotationY(rotation).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{direction}).condition(WineShelfBlock.WINE_SHELF_SLOT_2, (Comparable[])new WineShelfBlock.Slot[]{slot}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(this.existingModel(name + "_slot_bottom_right")).rotationY(rotation).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{direction}).condition(WineShelfBlock.WINE_SHELF_SLOT_3, (Comparable[])new WineShelfBlock.Slot[]{slot}).end();
    }

    public ResourceLocation withSuffix(ResourceLocation resourceLocation, String suffix) {
        return new ResourceLocation(resourceLocation.m_135827_(), resourceLocation.m_135815_() + suffix);
    }

    private static /* synthetic */ ModelFile lambda$candleCakeBlock$8(ModelFile candleCakeLit, ModelFile candleCake, BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_) != false ? candleCakeLit : candleCake;
    }
}

