/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.item;

import de.teamlapen.vampirism.VampirismMod;
import java.util.List;
import java.util.function.Consumer;
import net.grid.vampiresdelight.common.utility.VDIntegrationUtils;
import net.grid.vampiresdelight.common.utility.VDTextUtils;
import net.grid.vampiresdelight.common.utility.VDTooltipUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.Configuration;

public class WerewolfConsumableItem
extends Item {
    private final FoodProperties werewolfFood;
    private final Consumer<LivingEntity> features;
    private final boolean hasFoodEffectTooltip;
    private final boolean hasHumanFoodEffectTooltip;
    private final boolean hasCustomTooltip;
    private final boolean hasFactionTooltip;

    public WerewolfConsumableItem(Item.Properties pProperties, FoodProperties werewolfFood, @Nullable Consumer<LivingEntity> features) {
        super(pProperties);
        this.werewolfFood = werewolfFood;
        this.features = features;
        this.hasFoodEffectTooltip = true;
        this.hasCustomTooltip = false;
        this.hasHumanFoodEffectTooltip = false;
        this.hasFactionTooltip = true;
    }

    public WerewolfConsumableItem(Item.Properties pProperties, FoodProperties werewolfFood, @Nullable Consumer<LivingEntity> features, boolean hasFoodEffectTooltip, boolean hasCustomTooltip, boolean hasHumanFoodEffectTooltip, boolean hasFactionTooltip) {
        super(pProperties);
        this.werewolfFood = werewolfFood;
        this.features = features;
        this.hasFoodEffectTooltip = hasFoodEffectTooltip;
        this.hasCustomTooltip = hasCustomTooltip;
        this.hasHumanFoodEffectTooltip = hasHumanFoodEffectTooltip;
        this.hasFactionTooltip = hasFactionTooltip;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity consumer) {
        Player player;
        if (!level.f_46443_) {
            if (this.features != null) {
                this.features.accept(consumer);
            }
            this.affectConsumer(stack, level, consumer);
        }
        ItemStack containerStack = stack.getCraftingRemainingItem();
        if (stack.m_41614_()) {
            super.m_5922_(stack, level, consumer);
        } else {
            Player player2 = player = consumer instanceof Player ? (Player)consumer : null;
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)player, stack);
            }
            if (player != null) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
        }
        if (stack.m_41619_()) {
            return containerStack;
        }
        if (consumer instanceof Player) {
            player = (Player)consumer;
            if (!((Player)consumer).m_150110_().f_35937_ && !player.m_150109_().m_36054_(containerStack)) {
                player.m_36176_(containerStack, false);
            }
        }
        return stack;
    }

    @Nullable
    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        if (entity == null) {
            entity = VampirismMod.proxy.getClientPlayer();
        }
        return VDIntegrationUtils.isWerewolf((Entity)entity) ? this.werewolfFood : super.getFoodProperties(stack, entity);
    }

    public void affectConsumer(ItemStack stack, Level level, LivingEntity consumer) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        Player player = VampirismMod.proxy.getClientPlayer();
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            if (this.hasCustomTooltip) {
                MutableComponent textEmpty = VDTextUtils.getTranslation("tooltip." + this, new Object[0]);
                tooltip.add((Component)textEmpty.m_130940_(ChatFormatting.BLUE));
            }
            if (this.hasFoodEffectTooltip && player != null && (VDIntegrationUtils.isWerewolf(player) || this.hasHumanFoodEffectTooltip)) {
                VDTextUtils.addFoodEffectTooltip(stack, (LivingEntity)player, tooltip);
            }
        }
        if (this.hasFactionTooltip && player != null) {
            VDTooltipUtils.addWerewolfFactionFoodToolTips(tooltip, player);
        }
    }
}

