/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.event;

import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.event.BloodDrinkEvent;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.VampirismItemBloodFoodItem;
import java.util.Objects;
import java.util.Optional;
import net.grid.vampiresdelight.common.item.HunterConsumableItem;
import net.grid.vampiresdelight.common.item.VampireConsumableItem;
import net.grid.vampiresdelight.common.item.WerewolfConsumableItem;
import net.grid.vampiresdelight.common.registry.VDAdvancementTriggers;
import net.grid.vampiresdelight.common.registry.VDStats;
import net.grid.vampiresdelight.common.tag.VDTags;
import net.grid.vampiresdelight.common.utility.VDEntityUtils;
import net.grid.vampiresdelight.common.utility.VDHelper;
import net.grid.vampiresdelight.common.utility.VDIntegrationUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.item.ConsumableItem;

@Mod.EventBusSubscriber(modid="vampiresdelight")
public class PlayerEventHandler {
    @SubscribeEvent
    public static void checkDisgustingFood(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LivingEntityUseItemEvent.Finish event) {
        ItemStack itemStack = event.getItem();
        Item item = itemStack.m_41720_();
        LivingEntity livingEntity = event.getEntity();
        if (!livingEntity.m_20193_().f_46443_) {
            if (VDHelper.isVampire((Entity)livingEntity)) {
                HunterConsumableItem hunterConsumableItem;
                if (item instanceof HunterConsumableItem && (hunterConsumableItem = (HunterConsumableItem)item).doesContainGarlic()) {
                    VDEntityUtils.affectVampireEntityWithGarlic(livingEntity, EnumStrength.MEDIUM);
                    PlayerEventHandler.disgustingFoodConsumed(livingEntity);
                }
                if (item == ModItems.GARLIC_BREAD.get()) {
                    PlayerEventHandler.disgustingFoodConsumed(livingEntity);
                }
            } else if (item instanceof VampireConsumableItem && itemStack.m_204117_(VDTags.VAMPIRE_FOOD) || item instanceof VampirismItemBloodFoodItem) {
                PlayerEventHandler.disgustingFoodConsumed(livingEntity);
            }
            if (!VDIntegrationUtils.isWerewolf((Entity)livingEntity) && item instanceof WerewolfConsumableItem && itemStack.m_204117_(VDTags.WEREWOLF_ONLY_FOOD)) {
                PlayerEventHandler.disgustingFoodConsumed(livingEntity);
            }
        }
    }

    private static void disgustingFoodConsumed(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_36220_(VDStats.disgusting_food_consumed);
            VDAdvancementTriggers.DISGUSTING_FOOD_CONSUMED.m_222618_((ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public static void onBloodFoodEaten(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LivingEntityUseItemEvent.Finish event) {
        ItemStack itemStack = event.getItem();
        LivingEntity livingEntity = event.getEntity();
        if (itemStack.m_204117_(VDTags.BLOOD_FOOD) && VDHelper.isVampire((Entity)livingEntity)) {
            VDEntityUtils.feedVampire(itemStack, event.getEntity().m_9236_(), livingEntity);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onFoodEaten(MobEffectEvent.Applicable event) {
        LivingEntity consumer = event.getEntity();
        ItemStack itemInHand = consumer.m_21120_(consumer.m_7655_());
        Item item = itemInHand.m_41720_();
        if (VDHelper.isVampire((Entity)consumer) && item instanceof ConsumableItem && !itemInHand.m_204117_(VDTags.BLOOD_FOOD)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onDrunkFromPoisonousPlayer(BloodDrinkEvent event) {
        Player player;
        Object t;
        Optional bloodSourceEntity = event.getBloodSource().getEntity();
        if (bloodSourceEntity.isPresent() && (t = bloodSourceEntity.get()) instanceof Player && Objects.equals((player = (Player)t).m_20148_().toString(), "052ef844-4947-452c-867d-902c8fa1cd94")) {
            LivingEntity biter = event.getVampire().getRepresentingEntity();
            biter.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 200, 1));
        }
    }
}

