/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.enchantment;

import net.grid.vampiresdelight.common.VDConfiguration;
import net.grid.vampiresdelight.common.registry.VDEnchantments;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class VampireBiteEnchantment
extends Enchantment {
    public VampireBiteEnchantment(Enchantment.Rarity rarity, EnchantmentCategory category) {
        super(rarity, category, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public static void healFromDamage(LivingEntity user, int level, float damage) {
        RandomSource randomSource = user.m_217043_();
        int chance = switch (level) {
            case 1 -> (Integer)VDConfiguration.VAMPIRE_BITE_HEALING_CHANCE_1.get();
            case 2 -> (Integer)VDConfiguration.VAMPIRE_BITE_HEALING_CHANCE_2.get();
            case 3 -> (Integer)VDConfiguration.VAMPIRE_BITE_HEALING_CHANCE_3.get();
            default -> 20;
        };
        int maxHealingValue = (int)((Double)VDConfiguration.VAMPIRE_BITE_MAX_HEALING_VALUE.get() * 2.0);
        if (user instanceof Player) {
            Player player = (Player)user;
            if (randomSource.m_188503_(100) <= chance) {
                float healAmount = (float)Math.ceil((double)level / 30.0 * (double)damage);
                if (!user.m_20193_().f_46443_) {
                    player.m_5634_(Math.min(healAmount, (float)maxHealingValue));
                }
            }
        }
    }

    public int m_6586_() {
        return 3;
    }

    public int m_6183_(int enchantmentLevel) {
        return enchantmentLevel * 30;
    }

    public int m_6175_(int enchantmentLevel) {
        return super.m_6183_(enchantmentLevel) + 50;
    }

    public boolean m_6591_() {
        return true;
    }

    public boolean m_6594_() {
        return false;
    }

    public boolean m_6592_() {
        return false;
    }

    public boolean m_6081_(ItemStack pStack) {
        return (Boolean)VDConfiguration.DISABLE_VAMPIRE_BITE.get() == false && super.m_6081_(pStack);
    }

    @Mod.EventBusSubscriber(modid="vampiresdelight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class VampireBiteEvent {
        @SubscribeEvent
        public static void onVampireBite(LivingHurtEvent event) {
            Entity entity = event.getSource().m_7639_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                ItemStack weapon = player.m_21205_();
                int enchantmentLevel = weapon.getEnchantmentLevel((Enchantment)VDEnchantments.VAMPIRE_BITE.get());
                if (!((Boolean)VDConfiguration.DISABLE_VAMPIRE_BITE.get()).booleanValue() || !player.m_20193_().f_46443_) {
                    VampireBiteEnchantment.healFromDamage((LivingEntity)player, enchantmentLevel, event.getAmount());
                }
            }
        }
    }
}

