/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.init.food;

import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.youkaishomecoming.content.item.food.FleshFoodItem;
import dev.xkmc.youkaishomecoming.content.item.food.YHDrinkItem;
import dev.xkmc.youkaishomecoming.content.item.food.YHFoodItem;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.data.YHTagGen;
import dev.xkmc.youkaishomecoming.init.food.EffectEntry;
import dev.xkmc.youkaishomecoming.init.registrate.YHItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public enum FoodType {
    SIMPLE(YHFoodItem::new, false, false, false, new TagKey[0]),
    FAST(YHFoodItem::new, false, true, false, new TagKey[0]),
    MEAT(YHFoodItem::new, true, false, false, new TagKey[0]),
    MEAT_SLICE(YHFoodItem::new, true, true, false, new TagKey[0]),
    STICK(p -> new YHFoodItem(p.m_41495_(Items.f_42398_).m_41487_(16)), false, true, false, new TagKey[0]),
    BOWL(p -> new YHFoodItem(p.m_41495_(Items.f_42399_).m_41487_(16)), false, false, false, new TagKey[0]),
    SAKE(p -> new YHDrinkItem(p.m_41495_(Items.f_42399_).m_41487_(16)), false, false, true, new TagKey[0]),
    BOTTLE(p -> new YHDrinkItem(p.m_41495_(Items.f_42590_).m_41487_(16)), false, false, true, new TagKey[0]),
    BAMBOO(p -> new YHDrinkItem(p.m_41495_(Items.f_41911_).m_41487_(16)), false, false, true, new TagKey[0]),
    BOTTLE_FAST(p -> new YHDrinkItem(p.m_41495_(Items.f_42590_).m_41487_(16)), false, true, true, new TagKey[0]),
    BOWL_MEAT(p -> new YHFoodItem(p.m_41495_(Items.f_42399_).m_41487_(16)), true, false, false, new TagKey[0]),
    FLESH(FleshFoodItem::new, true, false, false, YHTagGen.FLESH_FOOD),
    FLESH_FAST(FleshFoodItem::new, true, true, false, YHTagGen.FLESH_FOOD),
    BOWL_FLESH(p -> new FleshFoodItem(p.m_41495_(Items.f_42399_).m_41487_(16)), true, false, false, YHTagGen.FLESH_FOOD),
    CAN_FLESH(p -> new FleshFoodItem(p.m_41495_((Item)YHItems.CAN.get()).m_41487_(64)), true, true, false, YHTagGen.FLESH_FOOD);

    private final Function<Item.Properties, Item> factory;
    private final boolean meat;
    private final boolean fast;
    private final boolean alwaysEat;
    private final TagKey<Item>[] tags;
    private final EffectEntry[] effs;

    @SafeVarargs
    private FoodType(Function<Item.Properties, Item> factory, boolean meat, boolean fast, boolean alwaysEat, EffectEntry[] effs, TagKey<Item> ... tags) {
        this.factory = factory;
        this.meat = meat;
        this.fast = fast;
        this.alwaysEat = alwaysEat;
        this.tags = tags;
        this.effs = effs;
    }

    @SafeVarargs
    private FoodType(Function<Item.Properties, Item> factory, boolean meat, boolean fast, boolean alwaysEat, TagKey<Item> ... tags) {
        this(factory, meat, fast, alwaysEat, new EffectEntry[0], tags);
    }

    public ItemEntry<Item> build(String folder, String name, int nutrition, float sat, TagKey<Item>[] tags, List<EffectEntry> effs) {
        FoodProperties.Builder food = new FoodProperties.Builder().m_38760_(nutrition).m_38758_(sat);
        if (this.meat) {
            food.m_38757_();
        }
        if (this.fast) {
            food.m_38766_();
        }
        if (this.alwaysEat) {
            food.m_38765_();
        }
        for (EffectEntry e : this.effs) {
            food.effect(e::getEffect, e.chance());
        }
        for (EffectEntry e : effs) {
            food.effect(e::getEffect, e.chance());
        }
        return ((ItemBuilder)YoukaisHomecoming.REGISTRATE.item(name, p -> this.factory.apply(p.m_41489_(food.m_38767_()))).model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx, new ResourceLocation[]{pvd.modLoc("item/" + folder + ctx.getName())})).tag(FoodType.getTags(this.tags, tags)).lang(Item::m_5524_, this.makeLang(name))).register();
    }

    public String makeLang(String id) {
        String name = YHItems.toEnglishName(id.toLowerCase(Locale.ROOT));
        if (this.isFlesh()) {
            name = name.replaceFirst("Flesh", "%1\\$s");
        }
        return YHItems.toEnglishName(name);
    }

    public boolean isFlesh() {
        return this == FLESH || this == BOWL_FLESH || this == FLESH_FAST || this == CAN_FLESH;
    }

    private static TagKey<Item>[] getTags(TagKey<Item>[] a, TagKey<Item>[] b) {
        ArrayList<TagKey<Item>> ans = new ArrayList<TagKey<Item>>(List.of(a));
        ans.addAll(List.of(b));
        return (TagKey[])ans.toArray(TagKey[]::new);
    }
}

