/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.init.data;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.data.YHBiomeTagsProvider;
import dev.xkmc.youkaishomecoming.init.food.YHCrops;
import dev.xkmc.youkaishomecoming.init.loot.YHLootGen;
import dev.xkmc.youkaishomecoming.init.registrate.YHEntities;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosAlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendLoot;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifier;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.registry.ModBlocks;

public class YHDatapackRegistriesGen
extends DatapackBuiltinEntriesProvider {
    private static final List<YHStructure> STRUCTURES = List.of(new YHStructure(YoukaisHomecoming.loc("youkai_nest"), YHBiomeTagsProvider.HAS_NEST, 24, 8, List.of(new ProtectedBlockProcessor(BlockTags.f_144287_), new RuleProcessor(List.of(YHDatapackRegistriesGen.injectData(Blocks.f_50087_, YHLootGen.NEST_CHEST), YHDatapackRegistriesGen.injectData(Blocks.f_50618_, YHLootGen.NEST_BARREL)))), Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData((EntityType)YHEntities.RUMIA.get(), 1, 1, 1)})))), new YHStructure(YoukaisHomecoming.loc("hakurei_shrine"), YHBiomeTagsProvider.HAS_SHRINE, 24, 8, List.of(new ProtectedBlockProcessor(BlockTags.f_144287_), new RuleProcessor(List.of(YHDatapackRegistriesGen.injectData(Blocks.f_50087_, YHLootGen.SHRINE_CHEST), YHDatapackRegistriesGen.injectData(Blocks.f_50618_, YHLootGen.SHRINE_BARREL), YHDatapackRegistriesGen.injectData((Block)ModBlocks.SPRUCE_CABINET.get(), YHLootGen.SHRINE_CABINET)))), Map.of()));
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().m_254916_(Registries.f_256911_, ctx -> {
        for (YHCrops e : YHCrops.values()) {
            e.registerConfigs(ctx);
        }
    }).m_254916_(Registries.f_256988_, ctx -> {
        for (YHCrops e : YHCrops.values()) {
            e.registerPlacements((BootstapContext<PlacedFeature>)ctx);
        }
    }).m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, YHDatapackRegistriesGen::registerBiomeModifiers).m_254916_(Registries.f_257011_, ctx -> {
        for (YHStructure e : STRUCTURES) {
            ctx.m_255272_(ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)e.id), (Object)new StructureProcessorList(e.processors()));
        }
    }).m_254916_(Registries.f_256948_, ctx -> {
        Holder.Reference empty = ctx.m_255420_(Registries.f_256948_).m_255043_(ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)new ResourceLocation("empty")));
        for (YHStructure e : STRUCTURES) {
            Holder.Reference list = ctx.m_255420_(Registries.f_257011_).m_255043_(ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)e.id()));
            ctx.m_255272_(ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)e.id()), (Object)new StructureTemplatePool((Holder)empty, List.of(Pair.of((Object)((Object)new SinglePiece(e.id(), (Holder<StructureProcessorList>)list, StructureTemplatePool.Projection.RIGID)), (Object)1))));
        }
    }).m_254916_(Registries.f_256944_, ctx -> {
        for (YHStructure e : STRUCTURES) {
            HolderSet.Named biome = ctx.m_255420_(Registries.f_256952_).m_254956_(e.biomes());
            Holder.Reference pool = ctx.m_255420_(Registries.f_256948_).m_255043_(ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)e.id()));
            ctx.m_255272_(ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)e.id()), (Object)new JigsawStructure(new Structure.StructureSettings((HolderSet)biome, e.spawns(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder)pool, 1, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), false, Heightmap.Types.WORLD_SURFACE_WG));
        }
    }).m_254916_(Registries.f_256998_, ctx -> {
        for (YHStructure e : STRUCTURES) {
            Holder.Reference str = ctx.m_255420_(Registries.f_256944_).m_255043_(ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)e.id));
            ctx.m_255272_(ResourceKey.m_135785_((ResourceKey)Registries.f_256998_, (ResourceLocation)e.id), (Object)new StructureSet((Holder)str, (StructurePlacement)new RandomSpreadStructurePlacement(e.spacing(), e.separation(), RandomSpreadType.LINEAR, e.id.hashCode() & Integer.MAX_VALUE)));
        }
    });

    private static void registerBiomeModifiers(BootstapContext<BiomeModifier> ctx) {
        HolderGetter biomes = ctx.m_255420_(Registries.f_256952_);
        HolderGetter features = ctx.m_255420_(Registries.f_256988_);
        YHDatapackRegistriesGen.registerMobSpawn(ctx, YoukaisHomecoming.loc("lamprey"), YHBiomeTagsProvider.LAMPREY, (HolderGetter<Biome>)biomes, new MobSpawnSettings.SpawnerData((EntityType)YHEntities.LAMPREY.get(), 5, 3, 5));
        YHDatapackRegistriesGen.registerMobSpawn(ctx, YoukaisHomecoming.loc("cirno"), YHBiomeTagsProvider.CIRNO, (HolderGetter<Biome>)biomes, new MobSpawnSettings.SpawnerData((EntityType)YHEntities.CIRNO.get(), 5, 1, 1));
        YHDatapackRegistriesGen.registerCropBiome(ctx, YHCrops.SOYBEAN, (HolderSet<Biome>)biomes.m_254956_(YHBiomeTagsProvider.SOYBEAN), (HolderGetter<PlacedFeature>)features);
        YHDatapackRegistriesGen.registerCropBiome(ctx, YHCrops.REDBEAN, (HolderSet<Biome>)biomes.m_254956_(YHBiomeTagsProvider.REDBEAN), (HolderGetter<PlacedFeature>)features);
        YHDatapackRegistriesGen.registerCropBiome(ctx, YHCrops.COFFEA, (HolderSet<Biome>)biomes.m_254956_(YHBiomeTagsProvider.COFFEA), (HolderGetter<PlacedFeature>)features);
        YHDatapackRegistriesGen.registerCropBiome(ctx, YHCrops.TEA, (HolderSet<Biome>)biomes.m_254956_(YHBiomeTagsProvider.TEA), (HolderGetter<PlacedFeature>)features);
        YHDatapackRegistriesGen.registerCropBiome(ctx, YHCrops.MANDRAKE, (HolderSet<Biome>)biomes.m_254956_(YHBiomeTagsProvider.MANDRAKE), (HolderGetter<PlacedFeature>)features);
        YHDatapackRegistriesGen.registerCropBiome(ctx, YHCrops.UDUMBARA, (HolderSet<Biome>)biomes.m_254956_(YHBiomeTagsProvider.UDUMBARA), (HolderGetter<PlacedFeature>)features);
    }

    private static void registerCropBiome(BootstapContext<BiomeModifier> ctx, YHCrops tree, HolderSet<Biome> set, HolderGetter<PlacedFeature> features) {
        ctx.m_255272_(ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)YoukaisHomecoming.loc(tree.getName())), (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(set, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{features.m_255043_(tree.getPlacementKey())}), GenerationStep.Decoration.VEGETAL_DECORATION));
    }

    private static void registerMobSpawn(BootstapContext<BiomeModifier> ctx, ResourceLocation rl, TagKey<Biome> tag, HolderGetter<Biome> biomes, MobSpawnSettings.SpawnerData entity) {
        ctx.m_255272_(ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)rl), (Object)new ForgeBiomeModifiers.AddSpawnsBiomeModifier((HolderSet)biomes.m_254956_(tag), List.of(entity)));
    }

    public YHDatapackRegistriesGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, BUILDER, Set.of("minecraft", "youkaishomecoming"));
    }

    @NotNull
    public String m_6055_() {
        return "Youkai's Homecoming Data";
    }

    private static ProcessorRule injectData(Block block, ResourceLocation table) {
        return new ProcessorRule((RuleTest)new BlockMatchTest(block), (RuleTest)AlwaysTrueTest.f_73954_, (PosRuleTest)PosAlwaysTrueTest.f_74188_, block.m_49966_(), (RuleBlockEntityModifier)new AppendLoot(table));
    }

    private record YHStructure(ResourceLocation id, TagKey<Biome> biomes, int spacing, int separation, List<StructureProcessor> processors, Map<MobCategory, StructureSpawnOverride> spawns) {
    }

    private static class SinglePiece
    extends SinglePoolElement {
        protected SinglePiece(ResourceLocation template, Holder<StructureProcessorList> list, StructureTemplatePool.Projection proj) {
            super(Either.left((Object)template), list, proj);
        }
    }
}

