/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.game.cirno;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.spell.mover.RectMover;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.ActualSpellCard;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.Ticker;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class CirnoIceStorm
extends ActualSpellCard {
    @Override
    public void tick(CardHolder holder) {
        super.tick(holder);
        if (this.tick % 10 == 0) {
            Mob mob;
            LivingEntity livingEntity = holder.self();
            if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_5448_() instanceof Frog) {
                holder.shoot(holder.prepareDanmaku(40, holder.forward(), YHDanmaku.Bullet.CIRCLE, DyeColor.LIGHT_BLUE));
                return;
            }
            Vec3 le = holder.target();
            if (le == null) {
                return;
            }
            Vec3 dir = holder.forward();
            if (dir.m_82542_(1.0, 0.0, 1.0).m_82553_() > 0.1) {
                dir = dir.m_82542_(1.0, 0.0, 1.0).m_82541_();
            }
            DanmakuHelper.Orientation ori = DanmakuHelper.getOrientation(dir);
            StateChange ans = new StateChange();
            ans.pos = holder.center();
            ans.init = ori.rotateDegrees(180.0);
            ans.normal = ori.normal();
            this.addTicker(ans);
        }
    }

    @SerialClass
    public static class StateChange
    extends Ticker<CirnoIceStorm> {
        @SerialClass.SerialField
        private Vec3 pos;
        @SerialClass.SerialField
        private Vec3 init;
        @SerialClass.SerialField
        private Vec3 normal;
        @SerialClass.SerialField
        private int r0 = 12;
        @SerialClass.SerialField
        private int n = 3;
        @SerialClass.SerialField
        private int m = 4;
        @SerialClass.SerialField
        private int t0 = 20;
        @SerialClass.SerialField
        private int t2 = 40;
        @SerialClass.SerialField
        private int dt = 20;
        @SerialClass.SerialField
        private double termSpeed = 1.0;
        @SerialClass.SerialField
        private double dr = 20.0;

        @Override
        public boolean tick(CardHolder holder, CirnoIceStorm card) {
            this.step(holder);
            super.tick(holder, card);
            return false;
        }

        private void step(CardHolder holder) {
            DanmakuHelper.Orientation o0;
            Vec3 le = holder.target();
            if (le == null) {
                return;
            }
            RandomSource r = holder.random();
            if (this.init == null) {
                this.pos = holder.center();
                Vec3 dir = le.m_82546_(holder.center()).m_82541_();
                this.init = DanmakuHelper.getOrientation(dir).rotateDegrees(90.0, 0.0);
                this.normal = dir.m_82537_(this.init);
            }
            if (this.tick < 0) {
                return;
            }
            if (this.tick == 0) {
                o0 = DanmakuHelper.getOrientation(this.init, this.normal);
                double acc = (double)this.r0 * 2.0 / (double)this.t0 / (double)this.t0;
                for (int i = 0; i < this.n; ++i) {
                    Vec3 front = o0.rotateDegrees(360.0 / (double)this.n * (double)i);
                    Vec3 vec = front.m_82490_(acc * (double)this.t0);
                    ItemDanmakuEntity e = holder.prepareDanmaku(this.t0, vec, YHDanmaku.Bullet.MENTOS, DyeColor.LIGHT_BLUE);
                    e.mover = new RectMover(this.pos, vec, front.m_82490_(-acc));
                    holder.shoot(e);
                }
            }
            if (this.tick == this.t0) {
                o0 = DanmakuHelper.getOrientation(this.init, this.normal);
                for (int i = 0; i < this.n; ++i) {
                    Vec3 f0 = o0.rotateDegrees(360.0 / (double)this.n * (double)i);
                    Vec3 p0 = this.pos.m_82549_(f0.m_82490_((double)this.r0));
                    Vec3 f1 = le.m_82546_(p0).m_82541_();
                    DanmakuHelper.Orientation o1 = DanmakuHelper.getOrientation(f1);
                    for (int j = 0; j < this.m; ++j) {
                        Vec3 vec = o1.rotateDegrees(((double)j - (double)(this.m - 1) * 0.5) * this.dr).m_82490_(this.termSpeed);
                        int t = this.t2 + r.m_188503_(this.dt);
                        ItemDanmakuEntity e = holder.prepareDanmaku(t, vec, YHDanmaku.Bullet.BALL, DyeColor.LIGHT_BLUE);
                        e.m_146884_(p0);
                        e.mover = new RectMover(p0, vec, Vec3.f_82478_);
                        holder.shoot(e);
                    }
                }
            }
        }
    }
}

