/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.base;

import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import dev.xkmc.youkaishomecoming.content.pot.base.BasePotBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import vectorwing.farmersdelight.common.block.CookingPotBlock;
import vectorwing.farmersdelight.common.block.state.CookingPotSupport;
import vectorwing.farmersdelight.common.loot.function.CopyMealFunction;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.MathUtils;

public abstract class BasePotBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<CookingPotSupport> SUPPORT = CookingPotBlock.SUPPORT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public BasePotBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(SUPPORT, (Comparable)CookingPotSupport.NONE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack heldStack = player.m_21120_(hand);
        if (heldStack.m_41619_() && player.m_6144_()) {
            level.m_46597_(pos, (BlockState)state.m_61124_(SUPPORT, (Comparable)(((CookingPotSupport)state.m_61143_(SUPPORT)).equals((Object)CookingPotSupport.HANDLE) ? this.getTrayState((LevelAccessor)level, pos) : CookingPotSupport.HANDLE)));
            level.m_5594_(null, pos, SoundEvents.f_12028_, SoundSource.BLOCKS, 0.7f, 1.0f);
        } else if (!level.f_46443_) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof BasePotBlockEntity) {
                BasePotBlockEntity maker = (BasePotBlockEntity)blockEntity;
                ItemStack servingStack = maker.useHeldItemOnMeal(heldStack);
                if (servingStack != ItemStack.f_41583_) {
                    if (!player.m_150109_().m_36054_(servingStack)) {
                        player.m_36176_(servingStack, false);
                    }
                    level.m_5594_(null, pos, SoundEvents.f_11675_, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)maker, (BlockPos)pos);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        FluidState fluid = level.m_6425_(context.m_8083_());
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
        return context.m_43719_().equals((Object)Direction.DOWN) ? (BlockState)state.m_61124_(SUPPORT, (Comparable)CookingPotSupport.HANDLE) : (BlockState)state.m_61124_(SUPPORT, (Comparable)this.getTrayState((LevelAccessor)level, pos));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return facing.m_122434_().equals((Object)Direction.Axis.Y) && !((CookingPotSupport)state.m_61143_(SUPPORT)).equals((Object)CookingPotSupport.HANDLE) ? (BlockState)state.m_61124_(SUPPORT, (Comparable)this.getTrayState(level, currentPos)) : state;
    }

    private CookingPotSupport getTrayState(LevelAccessor level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_204336_(ModTags.TRAY_HEAT_SOURCES) ? CookingPotSupport.TRAY : CookingPotSupport.NONE;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack stack = super.m_7397_(level, pos, state);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BasePotBlockEntity) {
            BasePotBlockEntity moka = (BasePotBlockEntity)blockEntity;
            CompoundTag nbt = moka.writeMeal(new CompoundTag());
            if (!nbt.m_128456_()) {
                stack.m_41700_("BlockEntityTag", (Tag)nbt);
            }
            if (moka.m_8077_()) {
                stack.m_41714_(moka.m_7770_());
            }
        }
        return stack;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof BasePotBlockEntity) {
                BasePotBlockEntity moka = (BasePotBlockEntity)blockEntity;
                Containers.m_19010_((Level)level, (BlockPos)pos, moka.getDroppableInventory());
                moka.getUsedRecipesAndPopExperience(level, Vec3.m_82512_((Vec3i)pos));
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, SUPPORT, WATERLOGGED});
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof BasePotBlockEntity) {
            BasePotBlockEntity pot = (BasePotBlockEntity)blockEntity;
            pot.setCustomName(stack.m_41786_());
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BasePotBlockEntity) {
            BasePotBlockEntity moka = (BasePotBlockEntity)blockEntity;
            ItemStackHandler inventory = moka.getInventory();
            return MathUtils.calcRedstoneFromItemHandler((IItemHandlerModifiable)inventory);
        }
        return 0;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public static void buildLoot(RegistrateBlockLootTables pvd, BasePotBlock block) {
        pvd.m_247577_((Block)block, LootTable.m_79147_().m_79161_((LootPool.Builder)pvd.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_((LootItemFunction.Builder)CopyMealFunction.builder())))));
    }
}

