/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.reimu;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.reimu.MaidenEntity;
import dev.xkmc.youkaishomecoming.content.spell.game.TouhouSpellCards;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.data.YHTagGen;
import dev.xkmc.youkaishomecoming.init.registrate.YHCriteriaTriggers;
import dev.xkmc.youkaishomecoming.init.registrate.YHEffects;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class ReimuEntity
extends MaidenEntity {
    @SerialClass.SerialField
    private final HashSet<UUID> verifiedPlayers = new HashSet();
    @SerialClass.SerialField
    private int feedCD = 0;

    public ReimuEntity(EntityType<? extends ReimuEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends MaidenEntity>)pEntityType, pLevel);
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.feedCD > 0) {
            --this.feedCD;
        }
        this.setFlag(16, this.feedCD > 0);
    }

    protected void m_21217_() {
        super.m_21217_();
        if (this.getFlag(16)) {
            boolean flag = this.m_20145_() ? this.f_19796_.m_188503_(15) == 0 : this.f_19796_.m_188499_();
            int i = MobEffects.f_19618_.m_19484_();
            if (flag) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i & 0xFF) / 255.0;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
            }
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        FoodProperties food;
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41614_() && (food = stack.getFoodProperties((LivingEntity)this)) != null) {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                if (this.feedCD == 0) {
                    if (stack.m_204117_(YHTagGen.FLESH_FOOD)) {
                        this.m_6710_((LivingEntity)player);
                        return InteractionResult.SUCCESS;
                    }
                    ItemStack remain = stack.getCraftingRemainingItem();
                    this.feedTrigger(sp, stack);
                    stack.m_41774_(1);
                    this.feedCD += food.m_38744_() * 100;
                    if (food.m_38749_().stream().anyMatch(e -> ((MobEffectInstance)e.getFirst()).m_19544_() == YHEffects.UDUMBARA.get())) {
                        this.verifiedPlayers.add(sp.m_20148_());
                        YHCriteriaTriggers.REIMU_HAPPY.m_222618_(sp);
                    }
                    if (stack.m_41780_() == UseAnim.DRINK) {
                        this.m_216990_(stack.m_41615_());
                    } else {
                        this.m_216990_(stack.m_41616_());
                    }
                    if (!remain.m_41619_()) {
                        sp.m_150109_().m_150079_(remain);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private void feedTrigger(ServerPlayer sp, ItemStack stack) {
        MinecraftServer sv = sp.m_20194_();
        if (sv == null) {
            return;
        }
        Advancement e = sv.m_129889_().m_136041_(YoukaisHomecoming.loc("main/feed_reimu"));
        if (e == null) {
            return;
        }
        AdvancementProgress prog = sp.m_8960_().m_135996_(e);
        float count = prog.m_8213_();
        YHCriteriaTriggers.FEED_REIMU.trigger(sp, stack);
        if (prog.m_8213_() > count) {
            this.m_9236_().m_7605_((Entity)this, (byte)18);
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 18) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
        } else {
            super.m_7822_(pId);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        TouhouSpellCards.setReimu(this);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }
}

