/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fastprojectileapi.collision;

import dev.xkmc.fastprojectileapi.collision.FastMap;
import dev.xkmc.fastprojectileapi.collision.FastMapInit;
import dev.xkmc.fastprojectileapi.collision.SectionCache;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;

public class EntityStorageCache {
    private static EntityStorageCache CACHE = null;
    private final ServerLevel sl;
    private final long time;
    private final FastMap<SectionCache> map = FastMapInit.createFastMap();

    public static EntityStorageCache get(ServerLevel sl) {
        if (CACHE != null && EntityStorageCache.CACHE.sl == sl && EntityStorageCache.CACHE.time == sl.m_46467_()) {
            return CACHE;
        }
        CACHE = new EntityStorageCache(sl);
        return CACHE;
    }

    public EntityStorageCache(ServerLevel sl) {
        this.sl = sl;
        this.time = sl.m_46467_();
    }

    private void checkSection(int x, int y, int z) {
        if (this.map.containsKey(x, y, z)) {
            return;
        }
        this.map.put(x, y, z, new SectionCache(this.sl, x, y, z));
    }

    public Iterable<Entity> foreach(AABB aabb, Predicate<Entity> filter) {
        int x0 = ((int)aabb.f_82288_ >> 4) - 1;
        int y0 = ((int)aabb.f_82289_ >> 4) - 1;
        int z0 = ((int)aabb.f_82290_ >> 4) - 1;
        int x1 = ((int)aabb.f_82291_ >> 4) + 1;
        int y1 = ((int)aabb.f_82292_ >> 4) + 1;
        int z1 = ((int)aabb.f_82293_ >> 4) + 1;
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (int x = x0; x <= x1; ++x) {
            for (int y = y0; y <= y1; ++y) {
                for (int z = z0; z <= z1; ++z) {
                    this.checkSection(x, y, z);
                    for (Entity e : this.map.get(x, y, z).intersect(aabb)) {
                        if (!aabb.m_82381_(e.m_20191_()) || !filter.test(e)) continue;
                        list.add(e);
                    }
                }
            }
        }
        return list;
    }
}

