/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.Pair;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;

public class Couple<T>
extends Pair<T, T>
implements Iterable<T> {
    private static final Couple<Boolean> TRUE_AND_FALSE = Couple.create(true, false);

    protected Couple(T first, T second) {
        super(first, second);
    }

    public static <T> Couple<T> create(T first, T second) {
        return new Couple<T>(first, second);
    }

    public static <T> Couple<T> create(Supplier<T> factory) {
        return new Couple<T>(factory.get(), factory.get());
    }

    public static <T> Couple<T> createWithContext(Function<Boolean, T> factory) {
        return new Couple<T>(factory.apply(true), factory.apply(false));
    }

    public T get(boolean first) {
        return (T)(first ? this.getFirst() : this.getSecond());
    }

    public void set(boolean first, T value) {
        if (first) {
            this.setFirst(value);
        } else {
            this.setSecond(value);
        }
    }

    public Couple<T> copy() {
        return Couple.create(this.first, this.second);
    }

    public <S> Couple<S> map(Function<T, S> function) {
        return Couple.create(function.apply(this.first), function.apply(this.second));
    }

    public <S> Couple<S> mapWithContext(BiFunction<T, Boolean, S> function) {
        return Couple.create(function.apply(this.first, true), function.apply(this.second, false));
    }

    public <S, R> Couple<S> mapWithParams(BiFunction<T, R, S> function, Couple<R> values) {
        return Couple.create(function.apply(this.first, values.first), function.apply(this.second, values.second));
    }

    public <S, R> Couple<S> mapNotNullWithParam(BiFunction<T, R, S> function, R value) {
        return Couple.create(this.first != null ? (T)function.apply(this.first, value) : null, this.second != null ? (T)function.apply(this.second, value) : null);
    }

    public boolean both(Predicate<T> test) {
        return test.test(this.getFirst()) && test.test(this.getSecond());
    }

    public boolean either(Predicate<T> test) {
        return test.test(this.getFirst()) || test.test(this.getSecond());
    }

    public void replace(Function<T, T> function) {
        this.setFirst(function.apply(this.getFirst()));
        this.setSecond(function.apply(this.getSecond()));
    }

    public void replaceWithContext(BiFunction<T, Boolean, T> function) {
        this.replaceWithParams(function, TRUE_AND_FALSE);
    }

    public <S> void replaceWithParams(BiFunction<T, S, T> function, Couple<S> values) {
        this.setFirst(function.apply(this.getFirst(), values.getFirst()));
        this.setSecond(function.apply(this.getSecond(), values.getSecond()));
    }

    @Override
    public void forEach(Consumer<? super T> consumer) {
        consumer.accept(this.getFirst());
        consumer.accept(this.getSecond());
    }

    public void forEachWithContext(BiConsumer<T, Boolean> consumer) {
        this.forEachWithParams(consumer, TRUE_AND_FALSE);
    }

    public <S> void forEachWithParams(BiConsumer<T, S> function, Couple<S> values) {
        function.accept(this.getFirst(), values.getFirst());
        function.accept(this.getSecond(), values.getSecond());
    }

    public Couple<T> swap() {
        return Couple.create(this.second, this.first);
    }

    public ListTag serializeEach(Function<T, CompoundTag> serializer) {
        return NBTHelper.writeCompoundList(ImmutableList.of((Object)this.first, (Object)this.second), serializer);
    }

    public static <S> Couple<S> deserializeEach(ListTag list, Function<CompoundTag, S> deserializer) {
        List<S> readCompoundList = NBTHelper.readCompoundList(list, deserializer);
        return new Couple<S>(readCompoundList.get(0), readCompoundList.get(1));
    }

    @Override
    public Iterator<T> iterator() {
        return new Couplerator(this);
    }

    public Stream<T> stream() {
        return Stream.of(this.first, this.second);
    }

    private static class Couplerator<T>
    implements Iterator<T> {
        int state;
        private final Couple<T> couple;

        public Couplerator(Couple<T> couple) {
            this.couple = couple;
            this.state = 0;
        }

        @Override
        public boolean hasNext() {
            return this.state != 2;
        }

        @Override
        public T next() {
            ++this.state;
            if (this.state == 1) {
                return (T)this.couple.first;
            }
            if (this.state == 2) {
                return (T)this.couple.second;
            }
            return null;
        }
    }
}

