/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPackets;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.simibubi.create.content.contraptions.actors.trainControls.ControlsHandler;
import com.simibubi.create.content.trains.HonkPacket;
import com.simibubi.create.content.trains.TrainHUDUpdatePacket;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.ControlsUtil;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import com.simibubi.create.infrastructure.config.AllConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class TrainHUD {
    public static final IGuiOverlay OVERLAY = TrainHUD::renderOverlay;
    static LerpedFloat displayedSpeed = LerpedFloat.linear();
    static LerpedFloat displayedThrottle = LerpedFloat.linear();
    static LerpedFloat displayedPromptSize = LerpedFloat.linear();
    static Double editedThrottle = null;
    static int hudPacketCooldown = 5;
    static int honkPacketCooldown = 5;
    public static Component currentPrompt;
    public static boolean currentPromptShadow;
    public static int promptKeepAlive;
    static boolean usedToHonk;

    public static void tick() {
        if (promptKeepAlive > 0) {
            --promptKeepAlive;
        } else {
            currentPrompt = null;
        }
        Minecraft mc = Minecraft.m_91087_();
        displayedPromptSize.chase(currentPrompt != null ? (double)(mc.f_91062_.m_92852_((FormattedText)currentPrompt) + 17) : 0.0, 0.5, LerpedFloat.Chaser.EXP);
        displayedPromptSize.tickChaser();
        Carriage carriage = TrainHUD.getCarriage();
        if (carriage == null) {
            return;
        }
        Train train = carriage.train;
        double value = Math.abs(train.speed) / (double)(train.maxSpeed() * AllConfigs.server().trains.manualTrainSpeedModifier.getF());
        value = Mth.m_14008_((double)(value + (double)0.05f), (double)0.0, (double)1.0);
        displayedSpeed.chase((float)((int)(value * 18.0)) / 18.0f, 0.5, LerpedFloat.Chaser.EXP);
        displayedSpeed.tickChaser();
        displayedThrottle.chase(editedThrottle != null ? editedThrottle : train.throttle, 0.75, LerpedFloat.Chaser.EXP);
        displayedThrottle.tickChaser();
        boolean isSprintKeyPressed = ControlsUtil.isActuallyPressed(mc.f_91066_.f_92091_);
        if (isSprintKeyPressed && honkPacketCooldown-- <= 0) {
            train.determineHonk((Level)mc.f_91073_);
            if (train.lowHonk != null) {
                AllPackets.getChannel().sendToServer((Object)new HonkPacket.Serverbound(train, true));
                honkPacketCooldown = 5;
                usedToHonk = true;
            }
        }
        if (!isSprintKeyPressed && usedToHonk) {
            AllPackets.getChannel().sendToServer((Object)new HonkPacket.Serverbound(train, false));
            honkPacketCooldown = 0;
            usedToHonk = false;
        }
        if (editedThrottle == null) {
            return;
        }
        if (Mth.m_14082_((double)editedThrottle, (double)train.throttle)) {
            editedThrottle = null;
            hudPacketCooldown = 5;
            return;
        }
        if (hudPacketCooldown-- <= 0) {
            AllPackets.getChannel().sendToServer((Object)new TrainHUDUpdatePacket.Serverbound(train, editedThrottle));
            hudPacketCooldown = 5;
        }
    }

    private static Carriage getCarriage() {
        AbstractContraptionEntity abstractContraptionEntity = ControlsHandler.getContraption();
        if (!(abstractContraptionEntity instanceof CarriageContraptionEntity)) {
            return null;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
        return cce.getCarriage();
    }

    public static void renderOverlay(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        AbstractContraptionEntity abstractContraptionEntity = ControlsHandler.getContraption();
        if (!(abstractContraptionEntity instanceof CarriageContraptionEntity)) {
            return;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
        Carriage carriage = cce.getCarriage();
        if (carriage == null) {
            return;
        }
        Entity cameraEntity = Minecraft.m_91087_().m_91288_();
        if (cameraEntity == null) {
            return;
        }
        BlockPos localPos = ControlsHandler.getControlsPos();
        if (localPos == null) {
            return;
        }
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)(width / 2 - 91), (float)(height - 29), 0.0f);
        AllGuiTextures.TRAIN_HUD_FRAME.render(graphics, -2, 1);
        AllGuiTextures.TRAIN_HUD_SPEED_BG.render(graphics, 0, 0);
        int w = (int)((float)AllGuiTextures.TRAIN_HUD_SPEED.width * displayedSpeed.getValue(partialTicks));
        int h = AllGuiTextures.TRAIN_HUD_SPEED.height;
        graphics.m_280398_(AllGuiTextures.TRAIN_HUD_SPEED.location, 0, 0, 0, (float)AllGuiTextures.TRAIN_HUD_SPEED.startX, (float)AllGuiTextures.TRAIN_HUD_SPEED.startY, w, h, 256, 256);
        int promptSize = (int)displayedPromptSize.getValue(partialTicks);
        if (promptSize > 1) {
            poseStack.m_85836_();
            poseStack.m_252880_((float)promptSize / -2.0f + 91.0f, -27.0f, 100.0f);
            AllGuiTextures.TRAIN_PROMPT_L.render(graphics, -3, 0);
            AllGuiTextures.TRAIN_PROMPT_R.render(graphics, promptSize, 0);
            graphics.m_280398_(AllGuiTextures.TRAIN_PROMPT.location, 0, 0, 0, (float)AllGuiTextures.TRAIN_PROMPT.startX + (128.0f - (float)promptSize / 2.0f), (float)AllGuiTextures.TRAIN_PROMPT.startY, promptSize, AllGuiTextures.TRAIN_PROMPT.height, 256, 256);
            poseStack.m_85849_();
            Font font = mc.f_91062_;
            if (currentPrompt != null && font.m_92852_((FormattedText)currentPrompt) < promptSize - 10) {
                poseStack.m_85836_();
                poseStack.m_252880_((float)font.m_92852_((FormattedText)currentPrompt) / -2.0f + 82.0f, -27.0f, 100.0f);
                if (currentPromptShadow) {
                    graphics.m_280430_(font, currentPrompt, 9, 4, 0x544D45);
                } else {
                    graphics.m_280614_(font, currentPrompt, 9, 4, 0x544D45, false);
                }
                poseStack.m_85849_();
            }
        }
        AllGuiTextures.TRAIN_HUD_DIRECTION.render(graphics, 77, -20);
        w = (int)((float)AllGuiTextures.TRAIN_HUD_THROTTLE.width * (1.0f - displayedThrottle.getValue(partialTicks)));
        int invW = AllGuiTextures.TRAIN_HUD_THROTTLE.width - w;
        graphics.m_280398_(AllGuiTextures.TRAIN_HUD_THROTTLE.location, invW, 0, 0, (float)(AllGuiTextures.TRAIN_HUD_THROTTLE.startX + invW), (float)AllGuiTextures.TRAIN_HUD_THROTTLE.startY, w, h, 256, 256);
        AllGuiTextures.TRAIN_HUD_THROTTLE_POINTER.render(graphics, Math.max(1, AllGuiTextures.TRAIN_HUD_THROTTLE.width - w) - 3, -2);
        StructureTemplate.StructureBlockInfo info = cce.getContraption().getBlocks().get(localPos);
        Direction initialOrientation = cce.getInitialOrientation().m_122428_();
        boolean inverted = false;
        if (info != null && info.f_74676_().m_61138_((Property)ControlsBlock.f_54117_)) {
            inverted = !((Direction)info.f_74676_().m_61143_((Property)ControlsBlock.f_54117_)).equals((Object)initialOrientation);
        }
        boolean reversing = ControlsHandler.currentlyPressed.contains(1);
        inverted ^= reversing;
        int angleOffset = (ControlsHandler.currentlyPressed.contains(2) ? -45 : 0) + (ControlsHandler.currentlyPressed.contains(3) ? 45 : 0);
        if (reversing) {
            angleOffset *= -1;
        }
        float snapSize = 22.5f;
        float diff = AngleHelper.getShortestAngleDiff(cameraEntity.m_146908_(), cce.yaw) + (float)(inverted ? -90 : 90);
        if (Math.abs(diff) < 60.0f) {
            diff = 0.0f;
        }
        float angle = diff + (float)angleOffset;
        float snappedAngle = snapSize * (float)Math.round(angle / snapSize) % 360.0f;
        poseStack.m_252880_(91.0f, -9.0f, 0.0f);
        poseStack.m_85841_(0.925f, 0.925f, 1.0f);
        PlacementHelpers.textured(poseStack, 0.0f, 0.0f, 1.0f, snappedAngle);
        poseStack.m_85849_();
    }

    public static boolean onScroll(double delta) {
        Carriage carriage = TrainHUD.getCarriage();
        if (carriage == null) {
            return false;
        }
        double prevThrottle = editedThrottle == null ? carriage.train.throttle : editedThrottle;
        editedThrottle = Mth.m_14008_((double)(prevThrottle + (double)((float)(delta > 0.0 ? 1 : -1) / 18.0f)), (double)0.0555555559694767, (double)1.0);
        return true;
    }

    static {
        promptKeepAlive = 0;
    }
}

