/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.redstone.DirectedDirectionalBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class FilteredDetectorFilterSlot
extends ValueBoxTransform.Sided {
    private boolean hasSlotAtBottom;

    public FilteredDetectorFilterSlot(boolean hasSlotAtBottom) {
        this.hasSlotAtBottom = hasSlotAtBottom;
    }

    @Override
    protected boolean isSideActive(BlockState state, Direction direction) {
        Direction targetDirection = DirectedDirectionalBlock.getTargetDirection(state);
        if (direction == targetDirection) {
            return false;
        }
        if (targetDirection.m_122424_() == direction) {
            return true;
        }
        if (targetDirection.m_122434_() != Direction.Axis.Y) {
            return direction == Direction.UP || direction == Direction.DOWN && this.hasSlotAtBottom;
        }
        if (targetDirection == Direction.UP) {
            direction = direction.m_122424_();
        }
        if (!this.hasSlotAtBottom) {
            return direction == state.m_61143_((Property)DirectedDirectionalBlock.f_54117_);
        }
        return direction.m_122434_() == ((Direction)state.m_61143_((Property)DirectedDirectionalBlock.f_54117_)).m_122427_().m_122434_();
    }

    @Override
    public void rotate(BlockState state, PoseStack ms) {
        super.rotate(state, ms);
        Direction facing = (Direction)state.m_61143_((Property)DirectedDirectionalBlock.f_54117_);
        if (facing.m_122434_() == Direction.Axis.Y) {
            return;
        }
        if (this.getSide() != Direction.UP) {
            return;
        }
        TransformStack.cast((PoseStack)ms).rotateZ((double)(-AngleHelper.horizontalAngle(facing) + 180.0f));
    }

    @Override
    protected Vec3 getSouthLocation() {
        return VecHelper.voxelSpace(8.0, 8.0, 15.5);
    }
}

