/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.tileentity.BasicLootBlockEntity;
import com.mrcrayfish.furniture.tileentity.BedsideCabinetBlockEntity;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BedsideCabinetBlock
extends FurnitureHorizontalBlock
implements EntityBlock {
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public BedsideCabinetBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] LEG_BACK_LEG = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)2.0, (double)3.0), Direction.SOUTH));
        VoxelShape[] LEG_FRONT_LEFT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)1.0, (double)0.0, (double)11.0, (double)3.0, (double)2.0, (double)13.0), Direction.SOUTH));
        VoxelShape[] LEG_FRONT_RIGHT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)13.0, (double)0.0, (double)11.0, (double)15.0, (double)2.0, (double)13.0), Direction.SOUTH));
        VoxelShape[] LEG_BACK_RIGHT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)3.0), Direction.SOUTH));
        VoxelShape[] TOP = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] HANDLE_BOTTOM = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)5.0, (double)5.0, (double)15.0, (double)11.0, (double)6.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] BASE_CLOSED = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)14.0, (double)15.0), Direction.SOUTH));
        VoxelShape[] HANDLE_TOP_CLOSED = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)5.0, (double)11.0, (double)15.0, (double)11.0, (double)12.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] BASE_OPEN = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)14.0, (double)13.0), Direction.SOUTH));
        VoxelShape[] DRAW_TOP_OPEN = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)0.0, (double)8.0, (double)20.0, (double)16.0, (double)14.0, (double)22.0), Direction.SOUTH));
        VoxelShape[] DRAW_BOTTOM_OPEN = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)0.0, (double)2.0, (double)13.0, (double)16.0, (double)8.0, (double)15.0), Direction.SOUTH));
        VoxelShape[] HANDLE_TOP_OPEN = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)5.0, (double)11.0, (double)22.0, (double)11.0, (double)12.0, (double)23.0), Direction.SOUTH));
        VoxelShape[] DRAW_INSIDE_BOTTOM = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)1.0, (double)8.0, (double)13.0, (double)15.0, (double)10.0, (double)20.0), Direction.SOUTH));
        VoxelShape[] DRAW_INSIDE_LEFT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)1.0, (double)10.0, (double)13.0, (double)3.0, (double)14.0, (double)20.0), Direction.SOUTH));
        VoxelShape[] DRAW_INSIDE_RIGHT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)13.0, (double)10.0, (double)13.0, (double)15.0, (double)14.0, (double)20.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(LEG_BACK_LEG[direction.m_122416_()]);
            shapes.add(LEG_FRONT_LEFT[direction.m_122416_()]);
            shapes.add(LEG_FRONT_RIGHT[direction.m_122416_()]);
            shapes.add(LEG_BACK_RIGHT[direction.m_122416_()]);
            shapes.add(TOP[direction.m_122416_()]);
            shapes.add(HANDLE_BOTTOM[direction.m_122416_()]);
            if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
                shapes.add(BASE_OPEN[direction.m_122416_()]);
                shapes.add(DRAW_TOP_OPEN[direction.m_122416_()]);
                shapes.add(DRAW_BOTTOM_OPEN[direction.m_122416_()]);
                shapes.add(HANDLE_TOP_OPEN[direction.m_122416_()]);
                shapes.add(DRAW_INSIDE_BOTTOM[direction.m_122416_()]);
                shapes.add(DRAW_INSIDE_LEFT[direction.m_122416_()]);
                shapes.add(DRAW_INSIDE_RIGHT[direction.m_122416_()]);
            } else {
                shapes.add(BASE_CLOSED[direction.m_122416_()]);
                shapes.add(HANDLE_TOP_CLOSED[direction.m_122416_()]);
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (((Direction)state.m_61143_((Property)DIRECTION)).m_122424_() == result.m_82434_()) {
            BlockEntity blockEntity;
            if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof BedsideCabinetBlockEntity) {
                BedsideCabinetBlockEntity cabinet = (BedsideCabinetBlockEntity)blockEntity;
                player.m_5893_((MenuProvider)cabinet);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{OPEN});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BedsideCabinetBlockEntity(pos, state);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BasicLootBlockEntity) {
            BasicLootBlockEntity blockEntity2 = (BasicLootBlockEntity)blockEntity;
            blockEntity2.updateOpenerCount();
        }
    }
}

