/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.eapi.jei;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.libmc.Auxiliaries;
import wile.engineersdecor.libmc.Registries;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("engineersdecor", "jei_plugin_uid");
    }

    public void registerRecipeTransferHandlers(@NotNull IRecipeTransferRegistration registration) {
    }

    public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
        HashSet<Item> blacklisted = new HashSet<Item>();
        for (Block block : Registries.getRegisteredBlocks()) {
            if (!ModConfig.isOptedOut(block) || !ForgeRegistries.ITEMS.getKey((Object)block.m_5456_()).m_135815_().equals(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_())) continue;
            blacklisted.add(block.m_5456_());
        }
        for (Item item : Registries.getRegisteredItems()) {
            if (!ModConfig.isOptedOut(item) || item instanceof BlockItem) continue;
            blacklisted.add(item);
        }
        if (!blacklisted.isEmpty()) {
            List blacklist = blacklisted.stream().map(ItemStack::new).collect(Collectors.toList());
            try {
                jeiRuntime.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, blacklist);
            }
            catch (Exception exception) {
                Auxiliaries.logger().warn("Exception in JEI opt-out processing: '" + exception.getMessage() + "', skipping further JEI optout processing.");
            }
        }
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        if (!ModConfig.isOptedOut(ModContent.getBlock("small_lab_furnace"))) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModContent.getBlock("small_lab_furnace")), new RecipeType[]{RecipeTypes.SMELTING});
        }
        if (!ModConfig.isOptedOut(ModContent.getBlock("small_electrical_furnace"))) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModContent.getBlock("small_electrical_furnace")), new RecipeType[]{RecipeTypes.SMELTING});
        }
    }
}

