/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.builtinservers;

import java.util.List;
import net.minecraft.client.multiplayer.ServerData;

public class ModConfig {
    private boolean badgeVisible = true;
    private final List<ServerConfig> builtinServers = List.of(new ServerConfig("Default Server", "127.0.0.1"));

    public boolean isBadgeVisible() {
        return this.badgeVisible;
    }

    public List<ServerConfig> getBuiltinServers() {
        return this.builtinServers;
    }

    public static class ServerConfig {
        private final String name;
        private final String address;
        private final boolean forced;

        public ServerConfig(String name, String address) {
            this.name = name;
            this.address = address;
            this.forced = false;
        }

        public String getName() {
            return this.name;
        }

        public String getAddress() {
            return this.address;
        }

        public boolean isForced() {
            return this.forced;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServerConfig that = (ServerConfig)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            return this.address.equals(that.address);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.address.hashCode();
            return result;
        }

        public static ServerConfig fromServerInfo(ServerData serverInfo) {
            return new ServerConfig(serverInfo.f_105362_, serverInfo.f_105363_);
        }
    }
}

