/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.common.shapes;

import com.abdelaziz.canary.common.shapes.CuboidVoxelSet;
import com.abdelaziz.canary.common.shapes.VoxelShapeAlignedCuboidOffset;
import com.abdelaziz.canary.common.shapes.VoxelShapeSimpleCube;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CubePointRange;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeAlignedCuboid
extends VoxelShapeSimpleCube {
    static final double LARGE_EPSILON = 1.0E-6;
    protected final int xSegments;
    protected final int ySegments;
    protected final int zSegments;

    public VoxelShapeAlignedCuboid(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, int xRes, int yRes, int zRes) {
        super(new CuboidVoxelSet(1 << xRes, 1 << yRes, 1 << zRes, minX, minY, minZ, maxX, maxY, maxZ), minX, minY, minZ, maxX, maxY, maxZ);
        this.xSegments = 1 << xRes;
        this.ySegments = 1 << yRes;
        this.zSegments = 1 << zRes;
    }

    public VoxelShapeAlignedCuboid(DiscreteVoxelShape voxels, int xSegments, int ySegments, int zSegments, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        super(voxels, minX, minY, minZ, maxX, maxY, maxZ);
        this.xSegments = xSegments;
        this.ySegments = ySegments;
        this.zSegments = zSegments;
    }

    private static double calculatePenetration(double aMin, double aMax, int segmentsPerUnit, double bMin, double bMax, double maxDist) {
        if (maxDist > 0.0) {
            double gap = aMin - bMax;
            if (gap >= -1.0E-7) {
                return Math.min(gap, maxDist);
            }
            if (segmentsPerUnit == 1) {
                return maxDist;
            }
            double wallPos = (double)Mth.m_14165_((double)((bMax - 1.0E-7) * (double)segmentsPerUnit)) / (double)segmentsPerUnit;
            if (wallPos < aMax - 1.0E-6) {
                return Math.min(maxDist, wallPos - bMax);
            }
            return maxDist;
        }
        double gap = aMax - bMin;
        if (gap <= 1.0E-7) {
            return Math.max(gap, maxDist);
        }
        if (segmentsPerUnit == 1) {
            return maxDist;
        }
        double wallPos = (double)Mth.m_14107_((double)((bMin + 1.0E-7) * (double)segmentsPerUnit)) / (double)segmentsPerUnit;
        if (wallPos > aMin + 1.0E-6) {
            return Math.max(maxDist, wallPos - bMin);
        }
        return maxDist;
    }

    @Override
    public VoxelShape m_83216_(double x, double y, double z) {
        return new VoxelShapeAlignedCuboidOffset(this, this.f_83211_, x, y, z);
    }

    @Override
    public double m_83245_(AxisCycle cycleDirection, AABB box, double maxDist) {
        if (Math.abs(maxDist) < 1.0E-7) {
            return 0.0;
        }
        double penetration = this.calculatePenetration(cycleDirection, box, maxDist);
        if (penetration != maxDist && this.intersects(cycleDirection, box)) {
            return penetration;
        }
        return maxDist;
    }

    private double calculatePenetration(AxisCycle dir, AABB box, double maxDist) {
        switch (dir) {
            case NONE: {
                return VoxelShapeAlignedCuboid.calculatePenetration(this.minX, this.maxX, this.xSegments, box.f_82288_, box.f_82291_, maxDist);
            }
            case FORWARD: {
                return VoxelShapeAlignedCuboid.calculatePenetration(this.minZ, this.maxZ, this.zSegments, box.f_82290_, box.f_82293_, maxDist);
            }
            case BACKWARD: {
                return VoxelShapeAlignedCuboid.calculatePenetration(this.minY, this.maxY, this.ySegments, box.f_82289_, box.f_82292_, maxDist);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public DoubleList m_7700_(Direction.Axis axis) {
        return new CubePointRange(axis.m_7863_(this.xSegments, this.ySegments, this.zSegments));
    }

    @Override
    protected double m_83256_(Direction.Axis axis, int index) {
        return (double)index / (double)axis.m_7863_(this.xSegments, this.ySegments, this.zSegments);
    }

    @Override
    protected int m_6595_(Direction.Axis axis, double coord) {
        int i = axis.m_7863_(this.xSegments, this.ySegments, this.zSegments);
        return Mth.m_14045_((int)Mth.m_14107_((double)(coord * (double)i)), (int)-1, (int)i);
    }
}

