/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.misc.MonsterType;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemMonsterList;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SetMonsterListMessage {
    private final Map<ResourceLocation, MonsterType> monsterList;

    public SetMonsterListMessage(Map<ResourceLocation, MonsterType> monsterList) {
        this.monsterList = monsterList;
    }

    public static void encode(SetMonsterListMessage message, FriendlyByteBuf buf) {
        buf.m_130130_(message.monsterList.size());
        for (ResourceLocation id : message.monsterList.keySet()) {
            buf.m_130085_(id);
            buf.m_130068_((Enum)message.monsterList.get(id));
        }
    }

    public static SetMonsterListMessage decode(FriendlyByteBuf buf) {
        HashMap monsterListOutput = Maps.newHashMap();
        int size = buf.m_130242_();
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = buf.m_130281_();
            MonsterType type = (MonsterType)buf.m_130066_(MonsterType.class);
            monsterListOutput.put(id, type);
        }
        return new SetMonsterListMessage(monsterListOutput);
    }

    public static void handle(SetMonsterListMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> SetMonsterListMessage.writeList(message, context));
        }
        context.setPacketHandled(true);
    }

    private static void writeList(SetMonsterListMessage message, NetworkEvent.Context context) {
        ServerPlayer sender = context.getSender();
        if (sender == null) {
            return;
        }
        ItemStack item = sender.m_21205_();
        if (item.m_150930_((Item)InitItems.MONSTER_LIST.get())) {
            ItemMonsterList.addMonster(item, message.monsterList);
        }
    }
}

