/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item.bauble;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidDamageEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityExtinguishingAgent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FireProtectBauble
implements IMaidBauble {
    public FireProtectBauble() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingDamage(MaidDamageEvent event) {
        int slot;
        EntityMaid maid = event.getMaid();
        DamageSource source = event.getSource();
        if (source.m_269533_(DamageTypeTags.f_268745_) && (slot = ItemsUtil.getBaubleSlotInMaid(maid, this)) >= 0) {
            event.setCanceled(true);
            ItemStack stack = maid.getMaidBauble().getStackInSlot(slot);
            stack.m_41622_(1, (LivingEntity)maid, m -> maid.sendItemBreakMessage(stack));
            maid.getMaidBauble().setStackInSlot(slot, stack);
            maid.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 300));
            if (!maid.f_19853_.f_46443_) {
                maid.f_19853_.m_7967_((Entity)new EntityExtinguishingAgent(maid.f_19853_, maid.m_20182_()));
            }
        }
    }
}

