/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.client.gui.item.MonsterListScreen;
import com.github.tartaricacid.touhoulittlemaid.entity.misc.MonsterType;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class ItemMonsterList
extends Item {
    private static final String TAG_NAME = "MonsterList";

    public static CompoundTag getMonsterList(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(TAG_NAME, 10)) {
            return tag.m_128469_(TAG_NAME);
        }
        return new CompoundTag();
    }

    public static void addMonster(ItemStack stack, Map<ResourceLocation, MonsterType> monsterList) {
        CompoundTag tag = stack.m_41698_(TAG_NAME);
        monsterList.forEach((key, value) -> tag.m_128405_(key.toString(), value.ordinal()));
    }

    public ItemMonsterList() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (handIn == InteractionHand.MAIN_HAND) {
            ItemStack stack = playerIn.m_21205_();
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.openMonsterListSetScreen(stack, playerIn));
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openMonsterListSetScreen(ItemStack stack, Player playerIn) {
        if (playerIn.f_19853_.f_46443_) {
            Minecraft.m_91087_().m_91152_((Screen)new MonsterListScreen(stack));
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"tooltips.touhou_little_maid.monster_list.desc").m_130940_(ChatFormatting.GRAY));
    }
}

