/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity.TileEntityItemStackChairRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ItemChair
extends Item {
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:cushion";

    public ItemChair() {
        super(new Item.Properties().m_41487_(1));
    }

    public static Data getData(ItemStack stack) {
        if (stack.m_41720_() == InitItems.CHAIR.get()) {
            return Data.deserialization(stack.m_41784_());
        }
        return new Data(DEFAULT_MODEL_ID, 0.0f, true, false);
    }

    public static ItemStack setData(ItemStack stack, Data data) {
        if (stack.m_41720_() == InitItems.CHAIR.get()) {
            Data.serialization(stack.m_41784_(), data);
        }
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void fillItemCategory(CreativeModeTab.Output items) {
        for (String key : CustomPackLoader.CHAIR_MODELS.getModelIdSet()) {
            float height = CustomPackLoader.CHAIR_MODELS.getModelMountedYOffset(key);
            boolean canRide = CustomPackLoader.CHAIR_MODELS.getModelTameableCanRide(key);
            boolean isNoGravity = CustomPackLoader.CHAIR_MODELS.getModelNoGravity(key);
            items.m_246342_(ItemChair.setData(new ItemStack((ItemLike)InitItems.CHAIR.get()), new Data(key, height, canRide, isNoGravity)));
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                Minecraft minecraft = Minecraft.m_91087_();
                return new TileEntityItemStackChairRenderer(minecraft.m_167982_(), minecraft.m_167973_());
            }
        });
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43719_() != Direction.DOWN) {
            Level world = context.m_43725_();
            BlockPos clickedPos = new BlockPlaceContext(context).m_8083_();
            AABB boundingBox = EntityChair.TYPE.m_20680_().m_20393_(Vec3.m_82539_((Vec3i)clickedPos));
            if (world.m_45772_(boundingBox) && world.m_45933_(null, boundingBox).isEmpty()) {
                ItemStack stack = context.m_43722_();
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    EntityChair chair = (EntityChair)EntityChair.TYPE.m_262451_(serverWorld, stack.m_41783_(), e -> {
                        if (stack.m_41788_()) {
                            e.m_6593_(stack.m_41611_());
                        }
                    }, context.m_8083_(), MobSpawnType.SPAWN_EGG, true, true);
                    if (chair == null) {
                        return InteractionResult.FAIL;
                    }
                    this.addExtraData(context, stack, chair);
                    world.m_7967_((Entity)chair);
                    world.m_6263_(null, chair.m_20185_(), chair.m_20186_(), chair.m_20189_(), SoundEvents.f_12642_, SoundSource.BLOCKS, 0.75f, 0.8f);
                }
                stack.m_41774_(1);
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
        }
        return InteractionResult.FAIL;
    }

    private void addExtraData(UseOnContext context, ItemStack stack, EntityChair chair) {
        Data data = Data.deserialization(stack.m_41784_());
        chair.setModelId(data.getModelId());
        chair.setMountedHeight(data.getHeight());
        chair.setTameableCanRide(data.isCanRide());
        chair.m_20242_(data.isNoGravity());
        chair.setOwner(context.m_43723_());
        float yaw = (float)Mth.m_14143_((float)((Mth.m_14177_((float)(context.m_7074_() - 180.0f)) + 22.5f) / 45.0f)) * 45.0f;
        chair.m_7678_(chair.m_20185_(), chair.m_20186_(), chair.m_20189_(), yaw, 0.0f);
        chair.m_5618_(yaw);
        chair.m_5616_(yaw);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component m_7626_(ItemStack stack) {
        Data data;
        if (FMLEnvironment.dist == Dist.CLIENT && CustomPackLoader.CHAIR_MODELS.getInfo((data = ItemChair.getData(stack)).getModelId()).isPresent()) {
            String name = CustomPackLoader.CHAIR_MODELS.getInfo(data.getModelId()).get().getName();
            return ParseI18n.parse(name);
        }
        return super.m_7626_(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"tooltips.touhou_little_maid.chair.place.desc").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tooltips.touhou_little_maid.chair.destroy.desc").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tooltips.touhou_little_maid.chair.gui.desc").m_130940_(ChatFormatting.GRAY));
        if (flagIn.m_7050_() && Screen.m_96638_()) {
            Data data = Data.deserialization(stack.m_41784_());
            tooltip.add((Component)Component.m_237113_((String)("Model Id: " + data.getModelId())).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)("Mounted Height: " + data.getHeight())).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)("Tameable Can Ride: " + data.isCanRide())).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)("Is No Gravity: " + data.isNoGravity())).m_130940_(ChatFormatting.GRAY));
        }
    }

    public static class Data {
        private static final String MODEL_ID_TAG = "ModelId";
        private static final String MOUNTED_HEIGHT_TAG = "MountedHeight";
        private static final String TAMEABLE_CAN_RIDE_TAG = "TameableCanRide";
        private static final String IS_NO_GRAVITY_TAG = "IsNoGravity";
        private final String modelId;
        private final float height;
        private final boolean canRide;
        private final boolean isNoGravity;

        public Data(String modelId, float height, boolean canRide, boolean isNoGravity) {
            this.modelId = modelId;
            this.height = height;
            this.canRide = canRide;
            this.isNoGravity = isNoGravity;
        }

        public static void serialization(@Nonnull CompoundTag nbt, Data data) {
            nbt.m_128359_(MODEL_ID_TAG, data.getModelId());
            nbt.m_128350_(MOUNTED_HEIGHT_TAG, data.getHeight());
            nbt.m_128379_(TAMEABLE_CAN_RIDE_TAG, data.isCanRide());
            nbt.m_128379_(IS_NO_GRAVITY_TAG, data.isNoGravity());
        }

        public static Data deserialization(@Nonnull CompoundTag nbt) {
            String modelId = ItemChair.DEFAULT_MODEL_ID;
            float height = 0.0f;
            boolean canRide = true;
            boolean isNoGravity = false;
            if (nbt.m_128425_(MODEL_ID_TAG, 8)) {
                modelId = nbt.m_128461_(MODEL_ID_TAG);
            }
            if (nbt.m_128425_(MOUNTED_HEIGHT_TAG, 5)) {
                height = nbt.m_128457_(MOUNTED_HEIGHT_TAG);
            }
            if (nbt.m_128425_(TAMEABLE_CAN_RIDE_TAG, 1)) {
                canRide = nbt.m_128471_(TAMEABLE_CAN_RIDE_TAG);
            }
            if (nbt.m_128425_(IS_NO_GRAVITY_TAG, 1)) {
                isNoGravity = nbt.m_128471_(IS_NO_GRAVITY_TAG);
            }
            return new Data(modelId, height, canRide, isNoGravity);
        }

        public String getModelId() {
            return this.modelId;
        }

        public float getHeight() {
            return this.height;
        }

        public boolean isCanRide() {
            return this.canRide;
        }

        public boolean isNoGravity() {
            return this.isNoGravity;
        }
    }
}

