/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IFarmTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TaskNormalFarm
implements IFarmTask {
    private static final ResourceLocation NAME = new ResourceLocation("touhou_little_maid", "farm");

    @Override
    public ResourceLocation getUid() {
        return NAME;
    }

    @Override
    public ItemStack getIcon() {
        return Items.f_42387_.m_7968_();
    }

    @Override
    public boolean isSeed(ItemStack stack) {
        ItemNameBlockItem blockNamedItem;
        Block block;
        Item item = stack.m_41720_();
        if (item == Items.f_42588_) {
            return true;
        }
        if (item instanceof ItemNameBlockItem && (block = (blockNamedItem = (ItemNameBlockItem)item).m_40614_()) instanceof IPlantable) {
            IPlantable plantable = (IPlantable)block;
            return plantable.getPlantType((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_) == PlantType.CROP && plantable.getPlant((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_).m_60734_() != Blocks.f_50016_;
        }
        return false;
    }

    @Override
    public boolean canHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        Block block = cropState.m_60734_();
        if (block instanceof CropBlock && ((CropBlock)block).m_52307_(cropState)) {
            return true;
        }
        return block == Blocks.f_50200_ && (Integer)cropState.m_61143_((Property)NetherWartBlock.f_54967_) >= 3;
    }

    @Override
    public void harvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        if (maid.m_21205_().m_41720_() instanceof HoeItem) {
            maid.destroyBlock(cropPos);
        } else {
            CombinedInvWrapper availableInv = maid.getAvailableInv(false);
            Block cropBlock = cropState.m_60734_();
            maid.f_19853_.m_46796_(2001, cropPos, Block.m_49956_((BlockState)cropState));
            if (cropBlock instanceof CropBlock) {
                CropBlock crop = (CropBlock)cropBlock;
                BlockEntity blockEntity = cropState.m_155947_() ? maid.f_19853_.m_7702_(cropPos) : null;
                maid.dropResourcesToMaidInv(cropState, maid.f_19853_, cropPos, blockEntity, maid, maid.m_21205_());
                maid.f_19853_.m_7731_(cropPos, crop.m_49966_(), 3);
                maid.f_19853_.m_142346_((Entity)maid, GameEvent.f_157792_, cropPos);
                return;
            }
            if (cropBlock == Blocks.f_50200_) {
                ItemStack dropItemStack = new ItemStack((ItemLike)Items.f_42588_);
                ItemStack remindItemStack = ItemHandlerHelper.insertItemStacked((IItemHandler)availableInv, (ItemStack)dropItemStack, (boolean)false);
                if (!remindItemStack.m_41619_()) {
                    Block.m_49840_((Level)maid.f_19853_, (BlockPos)cropPos, (ItemStack)remindItemStack);
                }
                maid.f_19853_.m_7731_(cropPos, Blocks.f_50200_.m_49966_(), 3);
                maid.f_19853_.m_142346_((Entity)maid, GameEvent.f_157792_, cropPos);
            }
        }
    }

    @Override
    public boolean canPlant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        ItemNameBlockItem blockNamedItem;
        Block block;
        BlockState aboveState = maid.f_19853_.m_8055_(basePos.m_7494_());
        if (!aboveState.m_247087_() || aboveState.m_278721_()) {
            return false;
        }
        if (seed.m_41720_() instanceof ItemNameBlockItem && (block = (blockNamedItem = (ItemNameBlockItem)seed.m_41720_()).m_40614_()) instanceof IPlantable) {
            IPlantable plantable = (IPlantable)block;
            return baseState.canSustainPlant((BlockGetter)maid.f_19853_, basePos, Direction.UP, plantable);
        }
        return false;
    }

    @Override
    public ItemStack plant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        ItemNameBlockItem blockNamedItem;
        Block block;
        if (seed.m_41720_() instanceof ItemNameBlockItem && (block = (blockNamedItem = (ItemNameBlockItem)seed.m_41720_()).m_40614_()) instanceof IPlantable) {
            maid.placeItemBlock(basePos.m_7494_(), seed);
        }
        return seed;
    }
}

