/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IFarmTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFarmMoveTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFarmPlantTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TaskCocoa
implements IFarmTask {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "cocoa");

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return Items.f_42533_.m_7968_();
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        MaidFarmMoveTask maidFarmMoveTask = new MaidFarmMoveTask(this, 0.6f){

            @Override
            protected boolean checkPathReach(EntityMaid maid, BlockPos pos) {
                for (int x = -1; x <= 1; ++x) {
                    for (int y = 0; y <= 1; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            if (!maid.canPathReach(pos.m_7918_(x, y, z))) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        };
        MaidFarmPlantTask maidFarmPlantTask = new MaidFarmPlantTask(this);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)((Object)maidFarmMoveTask)), Pair.of((Object)6, (Object)((Object)maidFarmPlantTask))});
    }

    @Override
    public boolean isSeed(ItemStack stack) {
        return stack.m_41720_() == Items.f_42533_;
    }

    @Override
    public boolean canHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        return cropState.m_60713_(Blocks.f_50262_) && (Integer)cropState.m_61143_((Property)CocoaBlock.f_51736_) >= 2;
    }

    @Override
    public void harvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        maid.destroyBlock(cropPos);
    }

    @Override
    public boolean canPlant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        baseState = maid.f_19853_.m_8055_(basePos = basePos.m_7494_());
        if (baseState.m_204336_(BlockTags.f_13111_) && seed.m_41720_() == Items.f_42533_) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState state = maid.f_19853_.m_8055_(basePos.m_121945_(direction));
                if (!state.m_247087_()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack plant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        if (seed.m_41720_() == Items.f_42533_) {
            basePos = basePos.m_7494_();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos directionPos = basePos.m_121945_(direction);
                if (seed.m_41619_() || !maid.canPlaceBlock(directionPos)) continue;
                Level world = maid.m_9236_();
                BlockState cocoaState = (BlockState)Blocks.f_50262_.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)direction.m_122424_());
                world.m_7731_(directionPos, cocoaState, 11);
                SoundType soundType = cocoaState.getSoundType((LevelReader)world, directionPos, (Entity)maid);
                world.m_5594_(null, directionPos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
                seed.m_41774_(1);
            }
        }
        return seed;
    }

    @Override
    public double getCloseEnoughDist() {
        return 2.5;
    }

    @Override
    public boolean checkCropPosAbove() {
        return false;
    }
}

