/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.tacz.utils;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.api.item.IGun;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.ItemStack;

public class GunBehaviorUtils {
    private static final TargetingConditions LONG_DISTANCE_TARGET_CONDITIONS = TargetingConditions.m_148353_().m_26883_((double)((Integer)MaidConfig.MAID_GUN_LONG_DISTANCE.get()).intValue());
    private static final TargetingConditions MEDIUM_DISTANCE_TARGET_CONDITIONS = TargetingConditions.m_148353_().m_26883_((double)((Integer)MaidConfig.MAID_GUN_MEDIUM_DISTANCE.get()).intValue());
    private static final TargetingConditions NEAR_DISTANCE_TARGET_CONDITIONS = TargetingConditions.m_148353_().m_26883_((double)((Integer)MaidConfig.MAID_GUN_NEAR_DISTANCE.get()).intValue());

    public static boolean canSee(EntityMaid maid, LivingEntity target) {
        ItemStack handItem = maid.m_21205_();
        IGun iGun = IGun.getIGunOrNull((ItemStack)handItem);
        if (iGun != null) {
            ResourceLocation gunId = iGun.getGunId(handItem);
            return TimelessAPI.getCommonGunIndex((ResourceLocation)gunId).map(index -> {
                String type = index.getType();
                String sniper = GunTabType.SNIPER.name().toLowerCase(Locale.ENGLISH);
                if (sniper.equals(type)) {
                    return LONG_DISTANCE_TARGET_CONDITIONS.m_26885_((LivingEntity)maid, target);
                }
                String shotgun = GunTabType.SHOTGUN.name().toLowerCase(Locale.ENGLISH);
                String pistol = GunTabType.PISTOL.name().toLowerCase(Locale.ENGLISH);
                if (shotgun.equals(type) || pistol.equals(type)) {
                    return NEAR_DISTANCE_TARGET_CONDITIONS.m_26885_((LivingEntity)maid, target);
                }
                return MEDIUM_DISTANCE_TARGET_CONDITIONS.m_26885_((LivingEntity)maid, target);
            }).orElse(BehaviorUtils.m_22667_((LivingEntity)maid, (LivingEntity)target));
        }
        return BehaviorUtils.m_22667_((LivingEntity)maid, (LivingEntity)target);
    }

    public static Optional<? extends LivingEntity> findFirstValidAttackTarget(EntityMaid maid) {
        if (maid.m_6274_().m_21952_(MemoryModuleType.f_148204_).isPresent()) {
            List list = (List)maid.m_6274_().m_21952_(MemoryModuleType.f_148204_).get();
            return list.stream().filter(e -> maid.m_6779_((LivingEntity)e) && GunBehaviorUtils.canSee(maid, e)).findAny();
        }
        return Optional.empty();
    }
}

