/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.slashblade;

import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.AnimatedGeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SlashBladeRender {
    private static final ResourceLocation RESOURCE_DEFAULT_MODEL = new ResourceLocation("slashblade", "model/blade.obj");
    private static final ResourceLocation RESOURCE_DEFAULT_TEXTURE = new ResourceLocation("slashblade", "model/blade.png");

    public static void renderSlashBlade(PoseStack matrixStack, MultiBufferSource bufferIn, int lightIn, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        stack.getCapability(CapabilitySlashBlade.BLADESTATE).ifPresent(bladeState -> {
            ResourceLocation texture = bladeState.getTexture().orElse(RESOURCE_DEFAULT_TEXTURE);
            WavefrontObject obj = BladeModelManager.getInstance().getModel((ResourceLocation)bladeState.getModel().orElse(null));
            String part = bladeState.isBroken() ? "blade_damaged" : "blade";
            BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)obj, (String)part, (ResourceLocation)texture, (PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)lightIn);
            BladeRenderState.renderOverridedLuminous((ItemStack)stack, (WavefrontObject)obj, (String)(part + "_luminous"), (ResourceLocation)texture, (PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)lightIn);
            BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)obj, (String)"sheath", (ResourceLocation)texture, (PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)lightIn);
            BladeRenderState.renderOverridedLuminous((ItemStack)stack, (WavefrontObject)obj, (String)"sheath_luminous", (ResourceLocation)texture, (PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)lightIn);
        });
    }

    public static void renderMaidBackSlashBlade(PoseStack matrixStack, MultiBufferSource bufferIn, int lightIn, ItemStack stack) {
        matrixStack.m_85837_(0.9, -0.25, 0.05);
        matrixStack.m_252781_(Axis.f_252393_.m_252977_(15.0f));
        matrixStack.m_85841_(0.007f, 0.007f, 0.007f);
        SlashBladeRender.renderSlashBlade(matrixStack, bufferIn, lightIn, stack);
    }

    public static void renderGeckoMaidBackSlashBlade(PoseStack matrixStack, MultiBufferSource bufferIn, int lightIn, ItemStack stack) {
        matrixStack.m_85837_(1.25, -0.25, 0.0);
        matrixStack.m_252781_(Axis.f_252393_.m_252977_(15.0f));
        matrixStack.m_85841_(0.01f, 0.01f, 0.01f);
        SlashBladeRender.renderSlashBlade(matrixStack, bufferIn, lightIn, stack);
    }

    public static void renderMaidMainhandSlashBlade(Mob maid, BedrockModel<Mob> model, PoseStack matrixStack, MultiBufferSource bufferIn, int lightIn, ItemStack stack, float partialTicks) {
        if (stack.m_41720_() instanceof ItemSlashBlade) {
            matrixStack.m_85836_();
            if (model.hasWaistPositioningModel(HumanoidArm.LEFT)) {
                model.translateToPositioningWaist(HumanoidArm.LEFT, matrixStack);
            } else {
                matrixStack.m_85837_(0.25, 0.85, 0.0);
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(-20.0f));
            }
            matrixStack.m_85837_(0.0, 0.0, -0.5);
            matrixStack.m_85841_(0.007f, 0.007f, 0.007f);
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            if (stack.m_41619_()) {
                return;
            }
            stack.getCapability(CapabilitySlashBlade.BLADESTATE).ifPresent(bladeState -> {
                ResourceLocation texture = bladeState.getTexture().orElse(RESOURCE_DEFAULT_TEXTURE);
                WavefrontObject obj = BladeModelManager.getInstance().getModel(bladeState.getModel().orElse(RESOURCE_DEFAULT_MODEL));
                String part = bladeState.isBroken() ? "blade_damaged" : "blade";
                BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)obj, (String)"sheath", (ResourceLocation)texture, (PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)lightIn);
                BladeRenderState.renderOverridedLuminous((ItemStack)stack, (WavefrontObject)obj, (String)"sheath_luminous", (ResourceLocation)texture, (PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)lightIn);
                long time = maid.f_19853_.m_46467_() - bladeState.getLastActionTime();
                if (time < 5L) {
                    float i = (float)time + partialTicks;
                    matrixStack.m_85837_(0.0, 0.0, -71.42857142857143);
                    matrixStack.m_252781_(Axis.f_252436_.m_252977_(60.0f + i * 48.0f));
                    matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                }
                BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)obj, (String)part, (ResourceLocation)texture, (PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)lightIn);
                BladeRenderState.renderOverridedLuminous((ItemStack)stack, (WavefrontObject)obj, (String)(part + "_luminous"), (ResourceLocation)texture, (PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)lightIn);
            });
            matrixStack.m_85849_();
        }
    }

    public static void renderMaidMainhandSlashBlade(LivingEntity maid, AnimatedGeoModel model, PoseStack matrixStack, MultiBufferSource bufferIn, int lightIn, ItemStack stack, float partialTicks) {
        if (stack.m_41720_() instanceof ItemSlashBlade) {
            matrixStack.m_85836_();
            if (!model.leftWaistBones().isEmpty()) {
                SlashBladeRender.translateToWaist(HumanoidArm.LEFT, matrixStack, model);
            } else {
                matrixStack.m_85837_(-0.25, 1.25, 0.0);
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(20.0f));
            }
            matrixStack.m_85837_(0.0, 0.0, -0.7);
            matrixStack.m_85841_(0.01f, 0.01f, 0.01f);
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            if (stack.m_41619_()) {
                return;
            }
            stack.getCapability(CapabilitySlashBlade.BLADESTATE).ifPresent(bladeState -> {
                ResourceLocation texture = bladeState.getTexture().orElse(RESOURCE_DEFAULT_TEXTURE);
                WavefrontObject obj = BladeModelManager.getInstance().getModel(bladeState.getModel().orElse(RESOURCE_DEFAULT_MODEL));
                String part = bladeState.isBroken() ? "blade_damaged" : "blade";
                BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)obj, (String)"sheath", (ResourceLocation)texture, (PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)lightIn);
                BladeRenderState.renderOverridedLuminous((ItemStack)stack, (WavefrontObject)obj, (String)"sheath_luminous", (ResourceLocation)texture, (PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)lightIn);
                long time = maid.f_19853_.m_46467_() - bladeState.getLastActionTime();
                if (time < 5L) {
                    float i = (float)time + partialTicks;
                    matrixStack.m_85837_(0.0, 0.0, -71.42857142857143);
                    matrixStack.m_252781_(Axis.f_252436_.m_252977_(60.0f + i * 48.0f));
                    matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                }
                BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)obj, (String)part, (ResourceLocation)texture, (PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)lightIn);
                BladeRenderState.renderOverridedLuminous((ItemStack)stack, (WavefrontObject)obj, (String)(part + "_luminous"), (ResourceLocation)texture, (PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)lightIn);
            });
            matrixStack.m_85849_();
        }
    }

    public static void renderMaidOffhandSlashBlade(BedrockModel<?> model, PoseStack matrixStack, MultiBufferSource bufferIn, int lightIn, ItemStack stack) {
        if (stack.m_41720_() instanceof ItemSlashBlade) {
            matrixStack.m_85836_();
            if (model.hasWaistPositioningModel(HumanoidArm.RIGHT)) {
                model.translateToPositioningWaist(HumanoidArm.RIGHT, matrixStack);
            } else {
                matrixStack.m_85837_(-0.25, 0.85, 0.0);
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(-5.0f));
            }
            matrixStack.m_85837_(0.0, 0.0, -0.5);
            matrixStack.m_85841_(0.007f, 0.007f, 0.007f);
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            SlashBladeRender.renderSlashBlade(matrixStack, bufferIn, lightIn, stack);
            matrixStack.m_85849_();
        }
    }

    public static void renderMaidOffhandSlashBlade(AnimatedGeoModel model, PoseStack matrixStack, MultiBufferSource bufferIn, int lightIn, ItemStack stack) {
        if (stack.m_41720_() instanceof ItemSlashBlade) {
            matrixStack.m_85836_();
            if (!model.rightWaistBones().isEmpty()) {
                SlashBladeRender.translateToWaist(HumanoidArm.RIGHT, matrixStack, model);
            } else {
                matrixStack.m_85837_(0.25, 1.25, 0.0);
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(5.0f));
            }
            matrixStack.m_85837_(0.0, 0.0, -0.7);
            matrixStack.m_85841_(0.01f, 0.01f, 0.01f);
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            SlashBladeRender.renderSlashBlade(matrixStack, bufferIn, lightIn, stack);
            matrixStack.m_85849_();
        }
    }

    private static void translateToWaist(HumanoidArm arm, PoseStack poseStack, AnimatedGeoModel geoModel) {
        if (arm == HumanoidArm.LEFT) {
            RenderUtils.prepMatrixForLocator(poseStack, geoModel.leftWaistBones());
        } else {
            RenderUtils.prepMatrixForLocator(poseStack, geoModel.rightWaistBones());
        }
    }
}

