/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.cache;

import com.github.tartaricacid.touhoulittlemaid.client.gui.block.ModelSwitcherGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.block.ModelSwitcherModelGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.cache.CacheScreen;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model.AbstractModelGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model.ChairModelGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model.MaidModelGui;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.ChairModelInfo;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.CustomModelPack;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityModelSwitcher;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class CacheIconManager {
    private static final LinkedList<MaidModelInfo> MAID_CACHE_QUEUE = new LinkedList();
    private static final LinkedList<ChairModelInfo> CHAIR_CACHE_QUEUE = new LinkedList();

    public static void clearCache() {
        MAID_CACHE_QUEUE.clear();
        CHAIR_CACHE_QUEUE.clear();
    }

    public static void addMaidPack(CustomModelPack<MaidModelInfo> customModelPack) {
        MAID_CACHE_QUEUE.addAll(customModelPack.getModelList());
    }

    public static void addChairPack(CustomModelPack<ChairModelInfo> customModelPack) {
        CHAIR_CACHE_QUEUE.addAll(customModelPack.getModelList());
    }

    public static void openMaidModelGui(EntityMaid maid) {
        MaidModelGui maidModelGui = new MaidModelGui(maid);
        if (MAID_CACHE_QUEUE.isEmpty()) {
            Minecraft.m_91087_().m_91152_((Screen)maidModelGui);
        } else {
            CacheScreen<EntityMaid, MaidModelInfo> maidCacheScreen = CacheIconManager.getMaidCacheScreen(maidModelGui);
            Minecraft.m_91087_().m_91152_(maidCacheScreen);
        }
    }

    public static void openChairModelGui(EntityChair chair) {
        ChairModelGui chairModelGui = new ChairModelGui(chair);
        if (CHAIR_CACHE_QUEUE.isEmpty()) {
            Minecraft.m_91087_().m_91152_((Screen)chairModelGui);
        } else {
            CacheScreen<EntityChair, ChairModelInfo> chairCacheScreen = CacheIconManager.getChairCacheScreen(chairModelGui);
            Minecraft.m_91087_().m_91152_(chairCacheScreen);
        }
    }

    public static void openModelSwitcherModelGui(EntityMaid maid, TileEntityModelSwitcher.ModeInfo info, ModelSwitcherGui modelSwitcherGui) {
        ModelSwitcherModelGui switcherModelGui = new ModelSwitcherModelGui(maid, info, modelSwitcherGui);
        if (MAID_CACHE_QUEUE.isEmpty()) {
            Minecraft.m_91087_().m_91152_((Screen)switcherModelGui);
        } else {
            CacheScreen<EntityMaid, MaidModelInfo> maidCacheScreen = CacheIconManager.getMaidCacheScreen(switcherModelGui);
            Minecraft.m_91087_().m_91152_(maidCacheScreen);
        }
    }

    private static CacheScreen<EntityMaid, MaidModelInfo> getMaidCacheScreen(AbstractModelGui<EntityMaid, MaidModelInfo> maidModelGui) {
        return new CacheScreen<EntityMaid, MaidModelInfo>(maidModelGui, (EntityType)InitEntities.MAID.get(), MAID_CACHE_QUEUE, (graphics, posX, posY, modelInfo, scaleModified, maid) -> {
            EntityCacheUtil.clearMaidDataResidue(maid, false);
            if (modelInfo.getEasterEgg() != null) {
                maid.setModelId("touhou_little_maid:easter_egg_model");
            } else {
                maid.setModelId(modelInfo.getModelId().toString());
            }
            int scale = scaleModified / 2;
            InventoryScreen.m_274545_((GuiGraphics)graphics, (int)(posX + scale), (int)(posY + scaleModified - 5), (int)((int)((double)((float)scale * modelInfo.getRenderItemScale()) * 0.9)), (float)-25.0f, (float)-20.0f, (LivingEntity)maid);
        });
    }

    private static CacheScreen<EntityChair, ChairModelInfo> getChairCacheScreen(ChairModelGui chairModelGui) {
        return new CacheScreen<EntityChair, ChairModelInfo>(chairModelGui, (EntityType)InitEntities.CHAIR.get(), CHAIR_CACHE_QUEUE, (graphics, posX, posY, modelInfo, scaleModified, chair) -> {
            chair.setModelId(modelInfo.getModelId().toString());
            int scale = scaleModified / 2;
            InventoryScreen.m_274545_((GuiGraphics)graphics, (int)(posX + scale), (int)(posY + scaleModified - 5), (int)((int)((double)((float)scale * modelInfo.getRenderItemScale()) * 0.9)), (float)-25.0f, (float)-20.0f, (LivingEntity)chair);
        });
    }
}

