/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity;

import com.github.tartaricacid.touhoulittlemaid.client.download.InfoGetManager;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadInfo;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadStatus;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.FlatColorButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.GuiDownloadButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.PackInfoButton;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ModelDownloadGui
extends Screen {
    private static final ResourceLocation BG = new ResourceLocation("touhou_little_maid", "textures/gui/download_background.png");
    private static final String PACK_FILE_SUFFIX = ".zip";
    private final Map<Long, String> crc32Infos = Maps.newHashMap();
    private final List<DownloadInfo> showInfos = Lists.newArrayList();
    private Condition condition = Condition.ALL;
    private EditBox textField;
    private boolean needReload = false;
    private int selectIndex = -1;
    private int currentPage;
    private int x;
    private int y;

    public ModelDownloadGui() {
        super((Component)Component.m_237113_((String)"New Model Pack Download GUI"));
        this.getCrc32Infos();
        this.checkDownloadInfo();
    }

    protected void m_7856_() {
        this.m_169413_();
        this.x = (this.f_96543_ - 420) / 2;
        this.y = (this.f_96544_ - 240) / 2;
        this.initShowInfos();
        this.addBaseButtons();
        this.addPackButtons();
        this.addPageButtons();
        this.addPackHandleButtons();
        this.addSearchBox();
    }

    private void addSearchBox() {
        String textCache = this.textField == null ? "" : this.textField.m_94155_();
        boolean focus = this.textField != null && this.textField.m_93696_();
        this.textField = new EditBox(this.getMinecraft().f_91062_, this.x + 273, this.y + 78, 144, 16, (Component)Component.m_237119_());
        this.textField.m_94202_(15986656);
        this.textField.m_93692_(focus);
        this.textField.m_94144_(textCache);
        this.textField.m_94201_();
        this.m_7787_((GuiEventListener)this.textField);
    }

    private void addPackHandleButtons() {
        if (0 <= this.selectIndex && this.selectIndex < this.showInfos.size()) {
            DownloadInfo info = this.showInfos.get(this.selectIndex);
            this.m_142416_((GuiEventListener)new FlatColorButton(this.x + 272, this.y + 50, 20, 20, (Component)Component.m_237119_(), b -> this.openPackWebsite(info)).setTooltips("gui.touhou_little_maid.resources_download.open_link"));
            this.m_142416_((GuiEventListener)new GuiDownloadButton(this.x + 294, this.y + 50, 102, 20, info, b -> {
                if (info.getStatus() == DownloadStatus.NOT_DOWNLOAD) {
                    info.setStatus(DownloadStatus.DOWNLOADING);
                    InfoGetManager.downloadPack(info);
                    this.m_7856_();
                } else if (info.getStatus() == DownloadStatus.NEED_UPDATE) {
                    this.updatePack(info);
                }
            }));
            this.m_142416_((GuiEventListener)new FlatColorButton(this.x + 398, this.y + 50, 20, 20, (Component)Component.m_237119_(), b -> this.deletePack(info)).setTooltips("gui.touhou_little_maid.resources_download.delete"));
        }
    }

    private void addPageButtons() {
        this.m_142416_((GuiEventListener)new FlatColorButton(this.x, this.y + 218, 40, 20, (Component)Component.m_237113_((String)"<"), b -> {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.m_7856_();
            }
        }));
        this.m_142416_((GuiEventListener)new FlatColorButton(this.x + 228, this.y + 218, 40, 20, (Component)Component.m_237113_((String)">"), b -> {
            if (this.currentPage * 4 + 4 <= this.showInfos.size()) {
                ++this.currentPage;
                this.m_7856_();
            }
        }));
    }

    private void addPackButtons() {
        int startIndex;
        for (int i = startIndex = this.currentPage * 4; i < startIndex + 4 && i < this.showInfos.size(); ++i) {
            DownloadInfo info = this.showInfos.get(i);
            int yOffset = this.y + 26 + (i - startIndex) * 48;
            int tmp = i;
            PackInfoButton button = new PackInfoButton(this.x, yOffset, info, b -> {
                this.selectIndex = tmp;
                this.m_7856_();
            });
            if (this.selectIndex == i) {
                button.setSelect(true);
            }
            this.m_142416_((GuiEventListener)button);
        }
    }

    private void addBaseButtons() {
        int i = 0;
        for (Condition c : Condition.values()) {
            int width = 52;
            int xPos = this.x + (width + 2) * i;
            String key = c.name().toLowerCase(Locale.US);
            String nameKey = "gui.touhou_little_maid.resources_download." + key;
            String descKey = nameKey + ".tips";
            Button button = Button.m_253074_((Component)Component.m_237115_((String)nameKey), b -> this.setCondition(c)).m_253046_(width, 20).m_252794_(xPos, this.y + 3).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)descKey))).m_253136_();
            if (this.condition.equals((Object)c)) {
                button.f_93623_ = false;
            }
            this.m_142416_((GuiEventListener)button);
            ++i;
        }
        this.m_142416_((GuiEventListener)new FlatColorButton(this.x + 400, this.y + 2, 20, 20, (Component)Component.m_237119_(), b -> this.getMinecraft().m_91152_(null)).setTooltips("gui.touhou_little_maid.skin.button.close"));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.touhou_little_maid.resources_download.open_folder"), b -> Util.m_137581_().m_137644_(CustomPackLoader.PACK_FOLDER.toFile())).m_252794_(this.x + 270, this.y + 218).m_253046_(150, 20).m_253136_());
    }

    private void initShowInfos() {
        this.showInfos.clear();
        switch (this.condition) {
            case MAID: {
                this.showInfos.addAll(InfoGetManager.getTypedDownloadInfoList(DownloadInfo.TypeEnum.MAID));
                break;
            }
            case CHAIR: {
                this.showInfos.addAll(InfoGetManager.getTypedDownloadInfoList(DownloadInfo.TypeEnum.CHAIR));
                break;
            }
            case SOUND: {
                this.showInfos.addAll(InfoGetManager.getTypedDownloadInfoList(DownloadInfo.TypeEnum.SOUND));
                break;
            }
            case UPDATE: {
                this.showInfos.addAll(InfoGetManager.DOWNLOAD_INFO_LIST_ALL.stream().filter(info -> info.getStatus() == DownloadStatus.NEED_UPDATE).toList());
                break;
            }
            default: {
                this.showInfos.addAll(InfoGetManager.DOWNLOAD_INFO_LIST_ALL);
            }
        }
        if (this.textField != null && StringUtils.isNotBlank((CharSequence)this.textField.m_94155_())) {
            String search = this.textField.m_94155_().toLowerCase(Locale.US);
            this.showInfos.removeIf(info -> !info.getKeyword().contains(search));
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float pPartialTick) {
        this.renderBase(graphics);
        this.renderSearchBox(graphics, mouseX, mouseY, pPartialTick);
        this.renderPageNumber(graphics);
        super.m_88315_(graphics, mouseX, mouseY, pPartialTick);
        this.renderBaseButtons(graphics);
        this.renderPackHandleButtons(graphics);
        this.renderNoDataTips(graphics);
        this.f_169369_.stream().filter(b -> b instanceof FlatColorButton).forEach(b -> ((FlatColorButton)((Object)b)).renderToolTip(graphics, this, mouseX, mouseY));
    }

    private void renderNoDataTips(GuiGraphics graphics) {
        if (!InfoGetManager.DOWNLOAD_INFO_LIST_ALL.isEmpty()) {
            return;
        }
        List split = this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)"gui.touhou_little_maid.resources_download.fail"), 200);
        int yOffset = this.y + 100;
        for (FormattedCharSequence sequence : split) {
            graphics.m_280364_(this.f_96547_, sequence, this.x + 134, yOffset, ChatFormatting.RED.m_126665_().intValue());
            yOffset += 12;
        }
    }

    private void renderPageNumber(GuiGraphics graphics) {
        int maxPage = (this.showInfos.size() - 1) / 4;
        String pageInfo = String.format("%d/%d", this.currentPage + 1, maxPage + 1);
        int n = this.x + 134 - this.f_96547_.m_92895_(pageInfo) / 2;
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280488_(this.f_96547_, pageInfo, n, this.y + 227 - 9 / 2, 15986656);
    }

    private void renderPackHandleButtons(GuiGraphics graphics) {
        if (0 <= this.selectIndex && this.selectIndex < this.showInfos.size()) {
            DownloadInfo info = this.showInfos.get(this.selectIndex);
            graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)info.getName()), this.x + 345, this.y + 34, 0xFFFFFF);
            graphics.m_280218_(BG, this.x + 400, this.y + 52, 0, 16, 16, 16);
            graphics.m_280218_(BG, this.x + 274, this.y + 52, 16, 16, 16, 16);
        }
    }

    private void renderBaseButtons(GuiGraphics graphics) {
        graphics.m_280218_(BG, this.x + 402, this.y + 4, 32, 16, 16, 16);
    }

    private void renderSearchBox(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.touhou_little_maid.resources_download.hot_search"), this.x + 274, this.y + 102, 0xFFFFFF);
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)"gui.touhou_little_maid.resources_download.hot_search_key"), this.x + 274, this.y + 115, 146, ChatFormatting.GRAY.m_126665_().intValue());
        this.textField.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
        if (this.textField.m_94155_().isEmpty() && !this.textField.m_93696_()) {
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.touhou_little_maid.resources_download.search").m_130940_(ChatFormatting.ITALIC), this.x + 277, this.y + 83, 0x777777);
        }
    }

    private void renderBase(GuiGraphics graphics) {
        graphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, -503316480, -503316480);
        graphics.m_280024_(this.x + 270, this.y + 26, this.x + 420, this.y + 72, -14474719, -14474719);
        graphics.m_280024_(this.x + 270, this.y + 74, this.x + 420, this.y + 216, -14474719, -14474719);
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        String value = this.textField.m_94155_();
        super.m_6574_(minecraft, width, height);
        this.textField.m_94144_(value);
    }

    public void m_86600_() {
        this.textField.m_94120_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.textField.m_6375_(mouseX, mouseY, button)) {
            this.m_7522_((GuiEventListener)this.textField);
            return true;
        }
        if (this.textField.m_93696_()) {
            this.textField.m_93692_(false);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.textField == null) {
            return false;
        }
        String perText = this.textField.m_94155_();
        if (this.textField.m_5534_(codePoint, modifiers)) {
            if (!Objects.equals(perText, this.textField.m_94155_())) {
                this.currentPage = 0;
                this.m_7856_();
            }
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean hasKeyCode = InputConstants.m_84827_((int)keyCode, (int)scanCode).m_84876_().isPresent();
        String preText = this.textField.m_94155_();
        if (hasKeyCode) {
            return true;
        }
        if (this.textField.m_7933_(keyCode, scanCode, modifiers)) {
            if (!Objects.equals(preText, this.textField.m_94155_())) {
                this.currentPage = 0;
                this.m_7856_();
            }
            return true;
        }
        return this.textField.m_93696_() && this.textField.m_94213_() && keyCode != 256 || super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void m_6697_(String text, boolean overwrite) {
        if (overwrite) {
            this.textField.m_94144_(text);
        } else {
            this.textField.m_94164_(text);
        }
    }

    public void m_7379_() {
        if (this.needReload && this.getMinecraft().f_91074_ != null) {
            this.getMinecraft().f_91065_.m_168714_((Component)Component.m_237115_((String)"gui.touhou_little_maid.resources_download.need_reload.title"));
            this.getMinecraft().f_91065_.m_168711_((Component)Component.m_237115_((String)"gui.touhou_little_maid.resources_download.need_reload.subtitle"));
            this.getMinecraft().f_91074_.m_213846_((Component)Component.m_237115_((String)"gui.touhou_little_maid.resources_download.need_reload.subtitle"));
        }
        super.m_7379_();
    }

    private void getCrc32Infos() {
        this.crc32Infos.clear();
        try {
            Files.walkFileTree(CustomPackLoader.PACK_FOLDER, EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().endsWith(ModelDownloadGui.PACK_FILE_SUFFIX)) {
                        ModelDownloadGui.this.crc32Infos.put(FileUtils.checksumCRC32((File)file.toFile()), file.toFile().getName());
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkDownloadInfo() {
        block0: for (DownloadInfo info : InfoGetManager.DOWNLOAD_INFO_LIST_ALL) {
            if (info.getStatus() != DownloadStatus.DOWNLOADING) {
                info.setStatus(DownloadStatus.NOT_DOWNLOAD);
            }
            for (Long crc32 : this.crc32Infos.keySet()) {
                if (crc32.equals(info.getChecksum())) {
                    info.setStatus(DownloadStatus.DOWNLOADED);
                    continue block0;
                }
                if (!info.getOldVersion().contains(crc32)) continue;
                info.setStatus(DownloadStatus.NEED_UPDATE);
                continue block0;
            }
        }
    }

    private void setCondition(Condition condition) {
        if (this.condition != condition) {
            this.condition = condition;
            this.currentPage = 0;
            this.m_7856_();
        }
    }

    private void openPackWebsite(DownloadInfo info) {
        String website = info.getWebsite();
        if (StringUtils.isNotBlank((CharSequence)website)) {
            this.getMinecraft().m_91152_((Screen)new ConfirmLinkScreen(yes -> {
                if (yes) {
                    Util.m_137581_().m_137646_(website);
                }
                this.getMinecraft().m_91152_((Screen)this);
            }, website, false));
        }
    }

    private void deletePack(DownloadInfo info) {
        Set<String> deleteFiles = this.getDeleteFiles(info);
        if (info.getStatus() == DownloadStatus.DOWNLOADED || info.getStatus() == DownloadStatus.NEED_UPDATE) {
            this.getMinecraft().m_91152_((Screen)new ConfirmScreen(yes -> this.deleteFilesAndReload(yes, deleteFiles), (Component)Component.m_237115_((String)"gui.touhou_little_maid.resources_download.delete.confirm"), (Component)Component.m_237115_((String)info.getName())));
        }
    }

    private void updatePack(DownloadInfo info) {
        Set<String> deleteFiles = this.getDeleteFiles(info);
        this.deleteFiles(deleteFiles);
        info.setStatus(DownloadStatus.DOWNLOADING);
        InfoGetManager.downloadPack(info);
        this.needReload = true;
        this.getCrc32Infos();
        this.checkDownloadInfo();
        this.m_7856_();
    }

    @NotNull
    private Set<String> getDeleteFiles(DownloadInfo info) {
        HashSet deleteFiles = Sets.newHashSet();
        deleteFiles.add(info.getFileName());
        info.getOldVersion().forEach(version -> {
            if (this.crc32Infos.containsKey(version)) {
                deleteFiles.add(this.crc32Infos.get(version));
            }
        });
        return deleteFiles;
    }

    private void deleteFiles(Set<String> deleteFiles) {
        for (String fileName : deleteFiles) {
            try {
                Path file = CustomPackLoader.PACK_FOLDER.resolve(fileName);
                if (!Files.isRegularFile(file, new LinkOption[0])) continue;
                Files.delete(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void deleteFilesAndReload(boolean yes, Set<String> deleteFiles) {
        if (yes) {
            this.deleteFiles(deleteFiles);
            this.needReload = true;
            this.getCrc32Infos();
            this.checkDownloadInfo();
            this.m_7856_();
        }
        this.getMinecraft().m_91152_((Screen)this);
    }

    public static enum Condition {
        ALL,
        MAID,
        CHAIR,
        SOUND,
        UPDATE;

    }
}

