/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.entity;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.AnimationManager;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.AnimationRegister;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.AnimatableEntity;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.controller.AnimationController;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.MolangParser;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.AnimatedGeoBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.AnimatedGeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.model.provider.data.EntityModelData;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.resource.GeckoLibCache;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2f;

public class GeckoMaidEntity<T extends Mob>
extends AnimatableEntity<T> {
    private static final ResourceLocation GECKO_DEFAULT_ID = new ResourceLocation("touhou_little_maid", "fox_miko");
    private static final ResourceLocation GECKO_DEFAULT_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/empty.png");
    private static final int FPS = 60;
    private final IMaid maid;
    private MaidModelInfo maidInfo;
    private final Vector2f headRot = new Vector2f();
    private float currentTick = -1.0f;
    private boolean modelDirty = false;
    private final MaidState<T> state;

    public GeckoMaidEntity(T mob, IMaid maid) {
        super(mob, 60);
        this.maid = maid;
        this.state = new MaidState<T>(mob);
        this.registerControllers();
    }

    public void registerControllers() {
        String animationName;
        String controllerName;
        int i;
        AnimationManager manager = AnimationManager.getInstance();
        for (i = 0; i < 8; ++i) {
            controllerName = String.format("pre_parallel_%d_controller", i);
            animationName = String.format("pre_parallel%d", i);
            this.addAnimationController(new AnimationController<GeckoMaidEntity>(this, controllerName, 0.0f, e -> manager.predicateParallel(e, animationName)));
        }
        this.addAnimationController(new AnimationController<GeckoMaidEntity>(this, "main", 2.0f, manager::predicateMain));
        this.addAnimationController(new AnimationController<GeckoMaidEntity>(this, "hold_offhand", 0.0f, manager::predicateOffhandHold));
        this.addAnimationController(new AnimationController<GeckoMaidEntity>(this, "hold_mainhand", 0.0f, manager::predicateMainhandHold));
        this.addAnimationController(new AnimationController<GeckoMaidEntity>(this, "swing", 2.0f, manager::predicateSwing));
        this.addAnimationController(new AnimationController<GeckoMaidEntity>(this, "use", 2.0f, manager::predicateUse));
        this.addAnimationController(new AnimationController<GeckoMaidEntity>(this, "beg", 2.0f, manager::predicateBeg));
        this.addAnimationController(new AnimationController<GeckoMaidEntity>(this, "passenger", 2.0f, manager::predicatePassengerAnimation));
        for (i = 0; i < 8; ++i) {
            controllerName = String.format("parallel_%d_controller", i);
            animationName = String.format("parallel%d", i);
            this.addAnimationController(new AnimationController<GeckoMaidEntity>(this, controllerName, 0.0f, e -> manager.predicateParallel(e, animationName)));
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            String controllerName2 = String.format("%s_controller", slot.m_20751_());
            this.addAnimationController(new AnimationController<GeckoMaidEntity>(this, controllerName2, 0.0f, e -> manager.predicateArmor(e, slot)));
        }
    }

    @Override
    public boolean setCustomAnimations(@NotNull AnimationEvent animationEvent) {
        Object object;
        List<Object> extraData = animationEvent.getExtraData();
        MolangParser parser = GeckoLibCache.getInstance().parser;
        if (!Minecraft.m_91087_().m_91104_() && extraData.size() == 1 && (object = extraData.get(0)) instanceof EntityModelData) {
            EntityModelData data = (EntityModelData)object;
            AnimationRegister.setParserValue(animationEvent, parser, data, this.maid);
            boolean update = super.setCustomAnimations(animationEvent);
            AnimatedGeoModel currentModel = this.getCurrentModel();
            if (currentModel != null && currentModel.head() != null) {
                AnimatedGeoBone head = currentModel.head();
                if (update) {
                    this.headRot.set(head.getRotationX(), head.getRotationY());
                }
                head.setRotationX(this.headRot.x + (float)Math.toRadians(data.headPitch));
                head.setRotationY(this.headRot.y + (float)Math.toRadians(data.netHeadYaw));
            }
            return update;
        }
        return super.setCustomAnimations(animationEvent);
    }

    @Override
    public ResourceLocation getModelLocation() {
        if (this.maidInfo != null && GeckoLibCache.getInstance().getGeoModels().containsKey(this.maidInfo.getModelId())) {
            return this.maidInfo.getModelId();
        }
        return GECKO_DEFAULT_ID;
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return this.maidInfo != null ? this.maidInfo.getTexture() : GECKO_DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getAnimationFileLocation() {
        if (this.maidInfo != null && GeckoLibCache.getInstance().getAnimations().containsKey(this.maidInfo.getModelId())) {
            return this.maidInfo.getModelId();
        }
        return GECKO_DEFAULT_ID;
    }

    @Override
    protected boolean forceUpdate(AnimationEvent<?> animationEvent) {
        float tick = (float)this.getCurrentTick(animationEvent);
        if (tick != this.currentTick) {
            this.currentTick = tick;
            this.state.updateState();
            this.modelDirty = false;
            return false;
        }
        if (this.modelDirty || !this.state.compareState()) {
            this.state.updateState();
            this.modelDirty = false;
            return true;
        }
        return false;
    }

    public IMaid getMaid() {
        return this.maid;
    }

    public MaidModelInfo getMaidInfo() {
        return this.maidInfo;
    }

    public void setMaidInfo(MaidModelInfo info) {
        if (this.maidInfo != info) {
            this.maidInfo = info;
            this.modelDirty = true;
        }
    }

    private static class MaidState<T extends Mob> {
        private final T maid;
        private float yHeadRot = 0.0f;
        private float yBodyRot = 0.0f;

        private MaidState(T maid) {
            this.maid = maid;
        }

        public boolean compareState() {
            return this.yHeadRot == ((Mob)this.maid).f_20885_ && this.yBodyRot == ((Mob)this.maid).f_20883_;
        }

        public void updateState() {
            this.yHeadRot = ((Mob)this.maid).f_20885_;
            this.yBodyRot = ((Mob)this.maid).f_20883_;
        }
    }
}

