/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.download;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadInfo;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadStatus;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.info.ServerCustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.util.ZipFileCheck;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.HttpUtil;
import net.minecraft.util.ProgressListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.versions.forge.ForgeVersion;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="touhou_little_maid", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class InfoGetManager {
    private static final String ROOT_URL = "https://tlmdl.cfpa.team/";
    private static final String INFO_JSON_URL = "https://tlmdl.cfpa.team/info.json";
    private static final String ROOT_URL_BACKUP = "http://tlm.cfpa.team:29434/";
    private static final String INFO_JSON_URL_BACKUP = "http://tlm.cfpa.team:29434/info.json";
    private static final int INFO_MAX_FILE_SIZE = 0x100000;
    private static final int PACK_MAX_FILE_SIZE = 0x1900000;
    private static final Path ROOT_FOLDER = InfoGetManager.getRootPath();
    private static final Path INFO_JSON_FILE = ROOT_FOLDER.resolve("info.json");
    private static final Path PACK_FOLDER = ROOT_FOLDER.resolve("file");
    private static boolean USE_BACKUP_URL = false;
    public static List<DownloadInfo> DOWNLOAD_INFO_LIST_ALL = Lists.newArrayList();
    public static List<DownloadInfo> DOWNLOAD_INFO_LIST_MAID = Lists.newArrayList();
    public static List<DownloadInfo> DOWNLOAD_INFO_LIST_CHAIR = Lists.newArrayList();
    public static List<DownloadInfo> DOWNLOAD_INFO_LIST_SOUND = Lists.newArrayList();
    public static Statue STATUE = Statue.FIRST;

    public static Map<String, String> getDownloadHeaders() {
        HashMap map = Maps.newHashMap();
        User user = Minecraft.m_91087_().m_91094_();
        WorldVersion currentVersion = SharedConstants.m_183709_();
        map.put("X-Minecraft-Username", user.m_92546_());
        map.put("X-Minecraft-UUID", user.m_92545_());
        map.put("X-Minecraft-Version", currentVersion.m_132493_());
        map.put("X-Minecraft-Version-ID", currentVersion.m_132492_());
        map.put("X-Forge-Version", ForgeVersion.getVersion());
        map.put("X-TLM-Version", ModList.get().getModFileById("touhou_little_maid").versionString());
        map.put("User-Agent", "Minecraft Java/" + currentVersion.m_132493_());
        return map;
    }

    public static void checkInfoJsonFile() {
        if (!ROOT_FOLDER.toFile().isDirectory()) {
            try {
                Files.createDirectories(ROOT_FOLDER, new FileAttribute[0]);
            }
            catch (IOException ioe) {
                ioe.fillInStackTrace();
                return;
            }
        }
        File infoJsonFile = INFO_JSON_FILE.toFile();
        try {
            InfoGetManager.downloadInfoJson(infoJsonFile);
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
    }

    public static String getFileMd5(File file) {
        String md5 = "";
        if (!file.isFile()) {
            return md5;
        }
        try (FileInputStream stream = new FileInputStream(file);){
            md5 = DigestUtils.md5Hex((InputStream)stream);
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
        return md5;
    }

    private static Path getRootPath() {
        Path configPath = null;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft != null && minecraft.f_91069_ != null) {
            URI gameUri = minecraft.f_91069_.toURI();
            configPath = Paths.get(gameUri).resolve("config");
        } else {
            configPath = Paths.get("./", new String[0]).resolve("config");
        }
        return configPath.resolve("touhou_little_maid");
    }

    private static void downloadInfoJson(File infoJsonFile) throws IOException {
        Proxy proxy = Minecraft.m_91087_().m_91096_();
        URL infoJsonUrl = new URL(INFO_JSON_URL);
        URL infoJsonUrlBackup = new URL(INFO_JSON_URL_BACKUP);
        String md5Previous = InfoGetManager.getFileMd5(infoJsonFile);
        CompletableFuture downloader = HttpUtil.m_216225_((File)infoJsonFile, (URL)infoJsonUrl, InfoGetManager.getDownloadHeaders(), (int)0x100000, null, (Proxy)proxy);
        ((CompletableFuture)((CompletableFuture)downloader.exceptionallyCompose(error -> {
            TouhouLittleMaid.LOGGER.warn("Line 1 is inaccessible, try to use line 2");
            USE_BACKUP_URL = true;
            return HttpUtil.m_216225_((File)infoJsonFile, (URL)infoJsonUrlBackup, InfoGetManager.getDownloadHeaders(), (int)0x100000, null, (Proxy)proxy);
        })).thenRun(() -> {
            InfoGetManager.loadInfoJson(infoJsonFile);
            TouhouLittleMaid.LOGGER.info("The download info file was successfully updated and loaded");
            String md5Current = InfoGetManager.getFileMd5(infoJsonFile);
            if (StringUtils.isBlank((CharSequence)md5Previous) || StringUtils.isBlank((CharSequence)md5Current)) {
                return;
            }
            STATUE = md5Previous.equals(md5Current) ? Statue.NOT_UPDATE : Statue.UPDATE;
        })).exceptionally(error -> {
            TouhouLittleMaid.LOGGER.warn("Failed to download info file, possibly due to network issues");
            return null;
        });
    }

    private static void loadInfoJson(File infoJsonFile) {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(infoJsonFile), StandardCharsets.UTF_8);){
            DOWNLOAD_INFO_LIST_ALL = (List)CustomPackLoader.GSON.fromJson((Reader)reader, new TypeToken<List<DownloadInfo>>(){}.getType());
            DOWNLOAD_INFO_LIST_ALL.forEach(DownloadInfo::decorate);
            DOWNLOAD_INFO_LIST_ALL.forEach(downloadInfo -> {
                if (downloadInfo.hasType(DownloadInfo.TypeEnum.MAID)) {
                    DOWNLOAD_INFO_LIST_MAID.add((DownloadInfo)downloadInfo);
                }
                if (downloadInfo.hasType(DownloadInfo.TypeEnum.CHAIR)) {
                    DOWNLOAD_INFO_LIST_CHAIR.add((DownloadInfo)downloadInfo);
                }
                if (downloadInfo.hasType(DownloadInfo.TypeEnum.SOUND)) {
                    DOWNLOAD_INFO_LIST_SOUND.add((DownloadInfo)downloadInfo);
                }
            });
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(InfoGetManager::checkInfoJsonFile);
    }

    public static void downloadPack(DownloadInfo info) {
        try {
            Proxy proxy = Minecraft.m_91087_().m_91096_();
            info.setStatus(DownloadStatus.DOWNLOADING);
            String rootUrl = USE_BACKUP_URL ? ROOT_URL_BACKUP : ROOT_URL;
            URL url = new URL(new URL(rootUrl), info.getUrl());
            File fileInTlmModel = CustomPackLoader.PACK_FOLDER.resolve(info.getFileName()).toFile();
            File fileInCache = PACK_FOLDER.resolve(info.getFileName()).toFile();
            if (!fileInCache.isFile() || FileUtils.checksumCRC32((File)fileInCache) != info.getChecksum()) {
                InfoGetManager.downloadPack(info, fileInCache, url, proxy, fileInTlmModel);
            } else {
                InfoGetManager.reloadPack(info, fileInCache, fileInTlmModel);
                InfoGetManager.sendDownloadMessage(Component.m_237110_((String)"gui.touhou_little_maid.resources_download.state.downloaded", (Object[])new Object[]{info.getFileName(), 0.943}));
            }
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
    }

    private static void downloadPack(DownloadInfo info, File fileInCache, URL url, Proxy proxy, File fileInTlmModel) {
        InfoGetManager.sendDownloadMessage(Component.m_237110_((String)"gui.touhou_little_maid.resources_download.state.downloading", (Object[])new Object[]{info.getFileName()}));
        StopWatch stopWatch = StopWatch.createStarted();
        CompletableFuture downloader = HttpUtil.m_216225_((File)fileInCache, (URL)url, InfoGetManager.getDownloadHeaders(), (int)0x1900000, (ProgressListener)info, (Proxy)proxy);
        ((CompletableFuture)downloader.thenRun(() -> {
            stopWatch.stop();
            InfoGetManager.sendDownloadMessage(Component.m_237110_((String)"gui.touhou_little_maid.resources_download.state.downloaded", (Object[])new Object[]{info.getFileName(), (double)stopWatch.getTime(TimeUnit.MILLISECONDS) / 1000.0}));
            try {
                InfoGetManager.reloadPack(info, fileInCache, fileInTlmModel);
            }
            catch (IOException e) {
                e.fillInStackTrace();
            }
        })).exceptionally(error -> {
            stopWatch.stop();
            info.setStatus(DownloadStatus.NOT_DOWNLOAD);
            TouhouLittleMaid.LOGGER.warn("Failed to download pack file, possibly due to network issues");
            return null;
        });
    }

    private static void reloadPack(DownloadInfo info, File fileInCache, File fileInTlmModel) throws IOException {
        if (ZipFileCheck.isZipFile(fileInCache)) {
            Files.copy(fileInCache.toPath(), fileInTlmModel.toPath(), StandardCopyOption.REPLACE_EXISTING);
            CustomPackLoader.readModelFromZipFile(fileInTlmModel);
            ServerCustomPackLoader.reloadPacks();
            info.setStatus(DownloadStatus.DOWNLOADED);
        } else {
            info.setStatus(DownloadStatus.NOT_DOWNLOAD);
            TouhouLittleMaid.LOGGER.error("{} file is corrupt and cannot be loaded.", (Object)info.getFileName());
        }
    }

    public static void sendDownloadMessage(MutableComponent component) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.m_213846_((Component)component);
        }
    }

    public static List<DownloadInfo> getTypedDownloadInfoList(DownloadInfo.TypeEnum typeEnum) {
        return switch (typeEnum) {
            case DownloadInfo.TypeEnum.CHAIR -> DOWNLOAD_INFO_LIST_CHAIR;
            case DownloadInfo.TypeEnum.SOUND -> DOWNLOAD_INFO_LIST_SOUND;
            default -> DOWNLOAD_INFO_LIST_MAID;
        };
    }

    public static int getPackMaxFileSize() {
        return 0x1900000;
    }

    public static Path getPackFolder() {
        return PACK_FOLDER;
    }

    public static enum Statue {
        FIRST,
        UPDATE,
        NOT_UPDATE;

    }
}

