/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.init;

import dev.xkmc.youkaishomecoming.compat.touhoulittlemaid.TLMRenderHandler;
import dev.xkmc.youkaishomecoming.content.client.CirnoWingsLayer;
import dev.xkmc.youkaishomecoming.content.client.FrogHatLayer;
import dev.xkmc.youkaishomecoming.content.client.FrogStrawHatModel;
import dev.xkmc.youkaishomecoming.content.client.KoishiHatModel;
import dev.xkmc.youkaishomecoming.content.client.SuwakoHatModel;
import dev.xkmc.youkaishomecoming.content.client.YHRecipeCategories;
import dev.xkmc.youkaishomecoming.content.entity.fairy.CirnoModel;
import dev.xkmc.youkaishomecoming.content.entity.lampery.LampreyModel;
import dev.xkmc.youkaishomecoming.content.entity.reimu.ReimuModel;
import dev.xkmc.youkaishomecoming.content.entity.rumia.BlackBallModel;
import dev.xkmc.youkaishomecoming.content.entity.rumia.RumiaModel;
import dev.xkmc.youkaishomecoming.content.pot.overlay.TileClientTooltip;
import dev.xkmc.youkaishomecoming.content.pot.overlay.TileInfoDisplay;
import dev.xkmc.youkaishomecoming.content.pot.overlay.TileTooltip;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.FrogRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterRecipeBookCategoriesEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="youkaishomecoming", bus=Mod.EventBusSubscriber.Bus.MOD)
public class YHClient {
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        if (ModList.get().isLoaded("touhou_little_maid")) {
            MinecraftForge.EVENT_BUS.register(TLMRenderHandler.class);
        }
    }

    @SubscribeEvent
    public static void registerOverlay(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.CROSSHAIR.id(), "info_tile", (IGuiOverlay)new TileInfoDisplay());
    }

    @SubscribeEvent
    public static void registerClientTooltip(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(TileTooltip.class, TileClientTooltip::new);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(LampreyModel.LAYER_LOCATION, LampreyModel::createBodyLayer);
        event.registerLayerDefinition(SuwakoHatModel.SUWAKO, SuwakoHatModel::createSuwakoHat);
        event.registerLayerDefinition(SuwakoHatModel.STRAW, SuwakoHatModel::createStrawHat);
        event.registerLayerDefinition(FrogStrawHatModel.STRAW, FrogStrawHatModel::createHat);
        event.registerLayerDefinition(KoishiHatModel.HAT, KoishiHatModel::createHat);
        event.registerLayerDefinition(RumiaModel.LAYER_LOCATION, RumiaModel::createBodyLayer);
        event.registerLayerDefinition(RumiaModel.HAIRBAND, RumiaModel::createHairbandLayer);
        event.registerLayerDefinition(BlackBallModel.LAYER_LOCATION, BlackBallModel::createBodyLayer);
        event.registerLayerDefinition(ReimuModel.LAYER_LOCATION, ReimuModel::createBodyLayer);
        event.registerLayerDefinition(ReimuModel.HAT_LOCATION, ReimuModel::createHatLayer);
        event.registerLayerDefinition(CirnoModel.LAYER_LOCATION, CirnoModel::createBodyLayer);
        event.registerLayerDefinition(CirnoModel.HAT_LOCATION, CirnoModel::createHatLayer);
        event.registerLayerDefinition(CirnoModel.WINGS_LOCATION, CirnoModel::createWingsLayer);
    }

    @SubscribeEvent
    public static void registerRecipeTab(RegisterRecipeBookCategoriesEvent event) {
        event.registerBookCategories(YoukaisHomecoming.MOKA, List.of(YHRecipeCategories.MOKA.get()));
        event.registerRecipeCategoryFinder((RecipeType)YHBlocks.MOKA_RT.get(), e -> YHRecipeCategories.MOKA.get());
        event.registerBookCategories(YoukaisHomecoming.KETTLE, List.of(YHRecipeCategories.KETTLE.get()));
        event.registerRecipeCategoryFinder((RecipeType)YHBlocks.KETTLE_RT.get(), e -> YHRecipeCategories.KETTLE.get());
    }

    @SubscribeEvent
    public static void addLayer(EntityRenderersEvent.AddLayers event) {
        LivingEntityRenderer livingEntityRenderer = event.getRenderer(EntityType.f_217012_);
        if (livingEntityRenderer instanceof FrogRenderer) {
            FrogRenderer r = (FrogRenderer)livingEntityRenderer;
            r.m_115326_(new FrogHatLayer(r, event.getEntityModels()));
        }
        if (ModList.get().isLoaded("touhou_little_maid")) {
            TLMRenderHandler.addLayers(event);
        }
    }

    @SubscribeEvent
    public static void registerReloadListener(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)resourceManager -> YHClient.registerWingsLayer()));
    }

    public static void registerWingsLayer() {
        EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
        Map skinMap = renderManager.getSkinMap();
        for (EntityRenderer renderer : skinMap.values()) {
            if (!(renderer instanceof LivingEntityRenderer)) continue;
            LivingEntityRenderer ler = (LivingEntityRenderer)renderer;
            YHClient.addLayer(renderManager, ler);
        }
        renderManager.f_114362_.forEach((e, r) -> {
            LivingEntityRenderer ler;
            if (r instanceof LivingEntityRenderer && (ler = (LivingEntityRenderer)r).m_7200_() instanceof HumanoidModel) {
                YHClient.addLayer(renderManager, ler);
            }
        });
    }

    private static <T extends LivingEntity, M extends HumanoidModel<T>> void addLayer(EntityRenderDispatcher manager, LivingEntityRenderer<T, M> ler) {
        Minecraft mc = Minecraft.m_91087_();
        ler.m_115326_(new CirnoWingsLayer<T, M>(ler, mc.m_167973_()));
    }
}

