/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.youkai;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.youkai.YoukaiEntity;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

@SerialClass
public class YoukaiTargetContainer {
    private final YoukaiEntity youkai;
    private final int maxSize;
    @SerialClass.SerialField
    private final LinkedHashSet<UUID> list = new LinkedHashSet();

    public YoukaiTargetContainer(YoukaiEntity youkai, int maxSize) {
        this.youkai = youkai;
        this.maxSize = maxSize;
    }

    public void tick() {
        if (this.youkai.m_9236_().m_5776_()) {
            return;
        }
        LivingEntity le = this.youkai.m_21188_();
        if (le != null && le.m_6084_() && le.m_142066_() && !this.list.contains(le.m_20148_())) {
            this.list.add(le.m_20148_());
        } else {
            le = this.youkai.m_5448_();
            if (le != null && le.m_6084_() && le.m_142066_()) {
                this.list.add(le.m_20148_());
            }
        }
        this.list.removeIf(e -> !this.isValid((UUID)e));
        if (this.list.size() > this.maxSize) {
            ArrayList<UUID> tmp = new ArrayList<UUID>(this.list);
            this.list.clear();
            this.list.addAll(tmp.subList(this.list.size() - this.maxSize, this.list.size()));
        }
    }

    private boolean isValid(UUID id) {
        LivingEntity le;
        Entity e = ((ServerLevel)this.youkai.m_9236_()).m_8791_(id);
        if (e instanceof LivingEntity && (le = (LivingEntity)e).m_6084_()) {
            return le.m_142066_();
        }
        return false;
    }

    public boolean contains(LivingEntity e) {
        return this.youkai.m_5448_() == e || this.list.contains(e.m_20148_());
    }

    public void checkTarget() {
        LivingEntity le;
        ArrayList<UUID> tmp;
        UUID id;
        Entity e;
        Level level = this.youkai.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        LivingEntity last = this.youkai.m_21188_();
        if ((last == null || !last.m_6084_() || !last.m_142066_()) && !this.list.isEmpty() && (e = sl.m_8791_(id = (tmp = new ArrayList<UUID>(this.list)).get(tmp.size() - 1))) instanceof LivingEntity && (le = (LivingEntity)e).m_6084_() && le.m_142066_()) {
            this.youkai.m_6703_(le);
        }
    }

    public List<LivingEntity> getTargets() {
        ArrayList<LivingEntity> ans = new ArrayList<LivingEntity>();
        Level level = this.youkai.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return ans;
        }
        ServerLevel sl = (ServerLevel)level;
        for (UUID id : this.list) {
            LivingEntity le;
            Entity e = sl.m_8791_(id);
            if (!(e instanceof LivingEntity) || !(le = (LivingEntity)e).m_6084_() || !le.m_142066_()) continue;
            ans.add(le);
        }
        return ans;
    }
}

