/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.youkai;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.youkai.MultiHurtByTargetGoal;
import dev.xkmc.youkaishomecoming.content.entity.youkai.SyncedData;
import dev.xkmc.youkaishomecoming.content.entity.youkai.YoukaiAttackGoal;
import dev.xkmc.youkaishomecoming.content.entity.youkai.YoukaiEntity;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.registrate.YHEffects;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class GeneralYoukaiEntity
extends YoukaiEntity {
    private static final ResourceLocation SPELL = YoukaisHomecoming.loc("ex_rumia");
    protected static final SyncedData SPELL_DATA = new SyncedData(GeneralYoukaiEntity::defineId, YOUKAI_DATA);
    private static final EntityDataAccessor<String> SPELL_MODEL = SPELL_DATA.define(SyncedData.STRING, "", "modelId");
    private int tickAggressive;

    private static <T> EntityDataAccessor<T> defineId(EntityDataSerializer<T> ser) {
        return SynchedEntityData.m_135353_(GeneralYoukaiEntity.class, ser);
    }

    public GeneralYoukaiEntity(EntityType<? extends GeneralYoukaiEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21530_();
    }

    @Override
    protected SyncedData data() {
        return SPELL_DATA;
    }

    @Nullable
    public String getModelId() {
        String ans = (String)this.f_19804_.m_135370_(SPELL_MODEL);
        if (ans.isEmpty()) {
            return null;
        }
        return ans;
    }

    public void syncModel() {
        String model = null;
        if (this.spellCard != null) {
            model = this.spellCard.getModelId();
        }
        if (model == null) {
            model = "";
        }
        this.f_19804_.m_135381_(SPELL_MODEL, (Object)model);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, new YoukaiAttackGoal<GeneralYoukaiEntity>(this, 16));
        this.f_21345_.m_25352_(6, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 24.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new MultiHurtByTargetGoal(this, GeneralYoukaiEntity.class));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, this::wouldAttack));
    }

    protected boolean wouldAttack(LivingEntity entity) {
        if (this.shouldIgnore(entity)) {
            return false;
        }
        return entity.m_21023_((MobEffect)YHEffects.YOUKAIFYING.get());
    }

    @Override
    public boolean shouldHurt(LivingEntity le) {
        if (this.shouldIgnore(le)) {
            return false;
        }
        return super.shouldHurt(le) || this.wouldAttack(le);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            if (this.m_5912_()) {
                if (this.tickAggressive < 20) {
                    ++this.tickAggressive;
                }
            } else if (this.tickAggressive > 0) {
                --this.tickAggressive;
            }
        }
    }

    @Override
    public boolean shouldShowSpellCircle() {
        return this.m_5912_();
    }

    @Override
    @Nullable
    public ResourceLocation getSpellCircle() {
        if (!this.shouldShowSpellCircle()) {
            return null;
        }
        return SPELL;
    }

    @Override
    public float getCircleSize(float pTick) {
        return this.tickAggressive == 0 ? 0.0f : Math.min(1.0f, ((float)this.tickAggressive + pTick) / 20.0f);
    }
}

