/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fastprojectileapi.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.xkmc.fastprojectileapi.entity.SimplifiedProjectile;
import dev.xkmc.fastprojectileapi.render.DanmakuRenderStates;
import dev.xkmc.fastprojectileapi.render.ProjectileRenderHelper;
import dev.xkmc.fastprojectileapi.render.ProjectileRenderer;
import dev.xkmc.fastprojectileapi.render.RenderableProjectileType;
import dev.xkmc.youkaishomecoming.init.data.YHModConfig;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public record DoubleLayerLaserType(ResourceLocation inner, ResourceLocation outer, int color) implements RenderableProjectileType<DoubleLayerLaserType, Ins>
{
    @Override
    public void start(MultiBufferSource buffer, Iterable<Ins> list) {
        boolean ADDITIVE = (Boolean)YHModConfig.CLIENT.laserRenderAdditive.get();
        boolean INVERT = (Boolean)YHModConfig.CLIENT.laserRenderInverted.get();
        double tran = (Double)YHModConfig.CLIENT.laserTransparency.get();
        int col = this.color & 0xFFFFFF | (int)(tran * 255.9) << 24;
        int add = (int)((double)(this.color & 0xFF) * tran) | (int)((double)(this.color >> 8 & 0xFF) * tran) << 8 | (int)((double)(this.color >> 16 & 0xFF) * tran) << 16 | 0xFF000000;
        VertexConsumer vc = buffer.m_6299_(DanmakuRenderStates.laser(this.inner));
        for (Ins e : list) {
            e.texInner(vc, -1);
        }
        if (ADDITIVE) {
            vc = buffer.m_6299_(DanmakuRenderStates.additive(this.outer));
            for (Ins e : list) {
                e.texOuter(false, vc, add);
            }
        }
        if (INVERT) {
            vc = buffer.m_6299_(DanmakuRenderStates.transparent(this.outer));
            for (Ins e : list) {
                e.texOuter(true, vc, col);
            }
        }
        if (!ADDITIVE && !INVERT) {
            vc = buffer.m_6299_(DanmakuRenderStates.transparent(this.outer));
            for (Ins e : list) {
                e.texOuter(false, vc, col);
            }
        }
    }

    @Override
    public void create(ProjectileRenderer r, SimplifiedProjectile e, PoseStack pose, float pTick) {
        PoseStack.Pose mat = pose.m_85850_();
        Matrix4f m4 = new Matrix4f((Matrix4fc)mat.m_252922_());
        Matrix3f m3 = new Matrix3f((Matrix3fc)mat.m_252943_());
        ProjectileRenderHelper.add(this, new Ins(m3, m4));
    }

    public record Ins(Matrix3f m3, Matrix4f m4) {
        public void texInner(VertexConsumer vc, int color) {
            float v0 = -0.167f;
            float v1 = 0.167f;
            this.renderPart(false, vc, color, 0, 1, v0, v0, v0, v1, v1, v0, v1, v1, 0.0f, 1.0f, 0.0f, 1.0f);
        }

        public void texOuter(boolean invert, VertexConsumer vc, int color) {
            float v0 = -0.5f;
            float v1 = 0.5f;
            this.renderPart(invert, vc, color, 0, 1, v0, v0, v0, v1, v1, v0, v1, v1, 0.0f, 1.0f, 0.0f, 1.0f);
        }

        private void renderPart(boolean invert, VertexConsumer vc, int color, int pMinY, int pMaxY, float pX0, float pZ0, float pX1, float pZ1, float pX2, float pZ2, float pX3, float pZ3, float pMinU, float pMaxU, float pMinV, float pMaxV) {
            this.renderQuad(invert, vc, color, pMinY, pMaxY, pX0, pZ0, pX1, pZ1, pMinU, pMaxU, pMinV, pMaxV);
            this.renderQuad(invert, vc, color, pMinY, pMaxY, pX3, pZ3, pX2, pZ2, pMinU, pMaxU, pMinV, pMaxV);
            this.renderQuad(invert, vc, color, pMinY, pMaxY, pX1, pZ1, pX3, pZ3, pMinU, pMaxU, pMinV, pMaxV);
            this.renderQuad(invert, vc, color, pMinY, pMaxY, pX2, pZ2, pX0, pZ0, pMinU, pMaxU, pMinV, pMaxV);
        }

        private void renderQuad(boolean invert, VertexConsumer pConsumer, int color, int pMinY, int pMaxY, float pMinX, float pMinZ, float pMaxX, float pMaxZ, float pMinU, float pMaxU, float pMinV, float pMaxV) {
            if (invert) {
                this.addVertex(pConsumer, color, pMaxY, pMaxX, pMaxZ, pMinU, pMinV);
                this.addVertex(pConsumer, color, pMinY, pMaxX, pMaxZ, pMinU, pMaxV);
                this.addVertex(pConsumer, color, pMinY, pMinX, pMinZ, pMaxU, pMaxV);
                this.addVertex(pConsumer, color, pMaxY, pMinX, pMinZ, pMaxU, pMinV);
            } else {
                this.addVertex(pConsumer, color, pMaxY, pMinX, pMinZ, pMaxU, pMinV);
                this.addVertex(pConsumer, color, pMinY, pMinX, pMinZ, pMaxU, pMaxV);
                this.addVertex(pConsumer, color, pMinY, pMaxX, pMaxZ, pMinU, pMaxV);
                this.addVertex(pConsumer, color, pMaxY, pMaxX, pMaxZ, pMinU, pMinV);
            }
        }

        private void addVertex(VertexConsumer vc, int color, int pY, float pX, float pZ, float pU, float pV) {
            vc.m_252986_(this.m4, pX, (float)pY, pZ).m_7421_(pU, pV).m_193479_(color).m_5752_();
        }
    }
}

