/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fastprojectileapi.collision;

import dev.xkmc.fastprojectileapi.collision.EntityStorageCache;
import dev.xkmc.fastprojectileapi.entity.BaseProjectile;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ProjectileHitHelper {
    @Nullable
    public static HitResult getHitResultOnMoveVector(BaseProjectile e, boolean checkBlock) {
        ServerLevel sl;
        EntityHitResult ehit;
        Vec3 src = e.m_20182_();
        Vec3 v = e.m_20184_();
        Level level = e.m_9236_();
        Vec3 dst = src.m_82549_(v);
        BlockHitResult hit = null;
        if (checkBlock && (hit = level.m_45547_(new ClipContext(src, dst, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)e))).m_6662_() != HitResult.Type.MISS) {
            dst = hit.m_82450_();
        }
        if (level instanceof ServerLevel && (ehit = ProjectileHitHelper.getEntityHitResult(sl = (ServerLevel)level, e, src, dst, e.m_20191_().m_82369_(v), e.m_20205_() / 2.0f)) != null) {
            hit = ehit;
        }
        return hit;
    }

    @Nullable
    public static EntityHitResult getEntityHitResult(ServerLevel level, BaseProjectile self, Vec3 src, Vec3 dst, AABB box, float radius) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        for (Entity e : EntityStorageCache.get(level).foreach(box.m_82400_((double)(1.0f + radius)), self::canHitEntity)) {
            double d1;
            AABB aabb;
            Optional optional;
            if (e == self || !(optional = (aabb = e.m_20191_().m_82400_((double)radius)).m_82371_(src, dst)).isPresent() || !((d1 = src.m_82557_((Vec3)optional.get())) < d0)) continue;
            entity = e;
            d0 = d1;
        }
        return entity == null ? null : new EntityHitResult(entity);
    }
}

