/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.world.structure;

import net.grid.vampiresdelight.common.registry.VDLootTables;
import net.grid.vampiresdelight.common.registry.VDStructures;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class LostCarriagePieces {
    private static final ResourceLocation LOCATION_1 = new ResourceLocation("vampiresdelight", "lost_carriage_1");
    private static final ResourceLocation LOCATION_2 = new ResourceLocation("vampiresdelight", "lost_carriage_2");
    private static final ResourceLocation LOCATION_3 = new ResourceLocation("vampiresdelight", "lost_carriage_3");
    private static final ResourceLocation LOCATION_4 = new ResourceLocation("vampiresdelight", "lost_carriage_4");

    public static void addPieces(StructureTemplateManager structureTemplateManager, StructurePieceAccessor pieceAccessor, RandomSource random, BlockPos pos) {
        ResourceLocation location = switch (random.m_188503_(4)) {
            case 0 -> LOCATION_1;
            case 1 -> LOCATION_2;
            case 2 -> LOCATION_3;
            default -> LOCATION_4;
        };
        pieceAccessor.m_142679_((StructurePiece)new LostCarriagePiece(structureTemplateManager, location, pos));
    }

    public static class LostCarriagePiece
    extends TemplateStructurePiece {
        public LostCarriagePiece(StructureTemplateManager pStructureTemplateManager, ResourceLocation pLocation, BlockPos pPos) {
            super((StructurePieceType)VDStructures.LOST_CARRIAGE_PIECE.get(), 0, pStructureTemplateManager, pLocation, pLocation.toString(), LostCarriagePiece.makeSettings(), pPos);
        }

        public LostCarriagePiece(StructureTemplateManager pStructureTemplateManager, CompoundTag pTag) {
            super((StructurePieceType)VDStructures.LOST_CARRIAGE_PIECE.get(), pTag, pStructureTemplateManager, id -> LostCarriagePiece.makeSettings());
        }

        protected void m_213704_(String pName, BlockPos pPos, ServerLevelAccessor pLevel, RandomSource pRandom, BoundingBox pBox) {
            if (pName.equals("chest")) {
                pLevel.m_7731_(pPos, Blocks.f_50016_.m_49966_(), 3);
                BlockEntity blockEntity = pLevel.m_7702_(pPos.m_7495_());
                if (blockEntity instanceof ChestBlockEntity) {
                    ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                    chest.m_59626_(VDLootTables.CHEST_LOST_CARRIAGE, pRandom.m_188505_());
                }
            }
        }

        public void m_213694_(WorldGenLevel pLevel, StructureManager pStructureManager, ChunkGenerator pGenerator, RandomSource pRandom, BoundingBox pBox, ChunkPos pChunkPos, BlockPos pPos) {
            super.m_213694_(pLevel, pStructureManager, pGenerator, pRandom, pBox, pChunkPos, pPos);
        }

        private static void setBlockWithChance(Block pBlock, BlockPos pPos, int chance, RandomSource pRandom, WorldGenLevel pLevel) {
            if (pRandom.m_188503_(100) <= chance) {
                pLevel.m_7731_(pPos, pBlock.m_49966_(), 3);
            }
        }

        private static BlockPos getGroundPosition(BlockPos pPos, WorldGenLevel pLevel) {
            BlockPos topPos = pPos;
            for (int i = 0; i < 10; ++i) {
                if (!pLevel.m_8055_(topPos).m_60795_()) {
                    return topPos;
                }
                topPos = topPos.m_7495_();
            }
            return null;
        }

        private static StructurePlaceSettings makeSettings() {
            return new StructurePlaceSettings().m_74379_(Rotation.NONE).m_74377_(Mirror.NONE).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74048_);
        }
    }
}

