/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.utility;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import net.grid.vampiresdelight.common.tag.VDCompatibilityTags;
import net.grid.vampiresdelight.common.tag.VDForgeTags;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VDIntegrationUtils {
    public static final String WEREWOLVES = "werewolves";
    public static final String APPLESKIN = "appleskin";
    private static IFaction<?> werewolfFaction = null;
    public static final ResourceLocation WOLF_BERRIES = new ResourceLocation("werewolves", "wolf_berries");
    public static final ResourceLocation LIVER = new ResourceLocation("werewolves", "liver");
    public static final ResourceLocation NOT_MEAT = new ResourceLocation("werewolves", "not_meat");
    public static final Tier SILVER_ITEM_TIER = new Tier(){

        public int m_6609_() {
            return 250;
        }

        public float m_6624_() {
            return 6.0f;
        }

        public float m_6631_() {
            return 2.0f;
        }

        public int m_6604_() {
            return 2;
        }

        public int m_6601_() {
            return 14;
        }

        @NotNull
        public Ingredient m_6282_() {
            return Ingredient.m_204132_(VDForgeTags.SILVER_INGOT);
        }

        public TagKey<Block> getTag() {
            return VDForgeTags.NEEDS_SILVER_TOOL;
        }
    };

    public static boolean isModPresent(String string) {
        return ModList.get().isLoaded(string);
    }

    public static IFaction<?> werewolfFaction() {
        if (werewolfFaction == null) {
            werewolfFaction = VampirismAPI.factionRegistry().getFactionByID(new ResourceLocation(WEREWOLVES, "werewolf"));
        }
        return werewolfFaction;
    }

    public static boolean isWerewolf(Entity entity) {
        Player player;
        if (entity instanceof Player && VDIntegrationUtils.isWerewolf(player = (Player)entity)) {
            return true;
        }
        IFaction faction = VampirismAPI.factionRegistry().getFaction(entity);
        return faction != null && faction.getID().m_135815_().equals("werewolf");
    }

    public static boolean isWerewolf(Player player) {
        IFaction<?> werewolf = VDIntegrationUtils.werewolfFaction();
        return werewolf != null && VampirismAPI.getFactionPlayerHandler((Player)player).map(h -> werewolf.equals(h.getCurrentFaction())).orElse(false) != false;
    }

    public static boolean hasSkill(Player player, ResourceLocation skillId) {
        LazyOptional playerHandler = player.m_6084_() ? VampirismAPI.getFactionPlayerHandler((Player)player) : LazyOptional.empty();
        ISkill requiredSkill = (ISkill)((IForgeRegistry)VampirismRegistries.SKILLS.get()).getValue(skillId);
        if (requiredSkill != null) {
            return playerHandler.map(IFactionPlayerHandler::getCurrentFactionPlayer).flatMap(p -> p.map(d -> d.getSkillHandler().isSkillEnabled(requiredSkill))).orElse(false);
        }
        return false;
    }

    public static boolean isWerewolfVegetarian(Player player) {
        return VDIntegrationUtils.hasSkill(player, NOT_MEAT);
    }

    public static boolean isMeat(@Nullable LivingEntity entity, ItemStack stack) {
        FoodProperties foodProperties = stack.getFoodProperties(entity);
        return stack.m_41614_() && foodProperties != null && (foodProperties.m_38746_() || stack.m_204117_(VDCompatibilityTags.WEREWOLF_FOOD));
    }

    public static boolean canWerewolfEatFood(LivingEntity entity, ItemStack stack) {
        Player player;
        return VDIntegrationUtils.isMeat(entity, stack) || !(entity instanceof Player) || !VDIntegrationUtils.isWerewolf(player = (Player)entity) || VDIntegrationUtils.isWerewolfVegetarian(player);
    }
}

