/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.block;

import de.teamlapen.vampirism.blocks.VampirismFlowerBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.world.VampirismWorld;
import net.grid.vampiresdelight.common.registry.VDBlocks;
import net.grid.vampiresdelight.common.registry.VDItems;
import net.grid.vampiresdelight.common.utility.VDHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import org.jetbrains.annotations.NotNull;

public class VampireOrchidCropBlock
extends CropBlock {
    public static final int MAX_AGE = 2;
    public static final IntegerProperty AGE = BlockStateProperties.f_61405_;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0)};
    private static final int BONEMEAL_INCREASE = 1;

    public VampireOrchidCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public int m_7419_() {
        return 2;
    }

    @NotNull
    public BlockState m_52289_(int age) {
        return age == 2 ? ((VampirismFlowerBlock)ModBlocks.VAMPIRE_ORCHID.get()).m_49966_() : super.m_52289_(age);
    }

    public void m_213898_(BlockState blockState, ServerLevel worldIn, BlockPos pos, RandomSource randomSource) {
        float f;
        int i;
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if ((worldIn.m_45524_(pos, 0) <= 12 || VampireOrchidCropBlock.isPosInArtificalVampireFogArea(pos, (Level)worldIn) || VDHelper.isPosInVampireBiome((BlockPos)pos, (LevelAccessor)worldIn)) && (i = this.m_52305_(blockState)) < this.m_7419_() && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)blockState, (randomSource.m_188503_((int)(25.0f / (f = VampireOrchidCropBlock.getGrowthSpeed((Block)this, (BlockGetter)worldIn, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            worldIn.m_7731_(pos, this.m_52289_(i + 1), 2);
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)blockState);
        }
    }

    private static boolean isPosInArtificalVampireFogArea(BlockPos pos, Level level) {
        return VampirismWorld.getOpt((Level)level).map(vh -> vh.isInsideArtificialVampireFogArea(pos)).orElse(false);
    }

    protected static float getGrowthSpeed(Block block, BlockGetter blockGetter, BlockPos pos) {
        boolean matchesNorthSouthRow;
        float speed = 1.0f;
        BlockPos blockpos = pos.m_7495_();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float speedBoost = 0.0f;
                BlockState blockstate = blockGetter.m_8055_(blockpos.m_7918_(i, 0, j));
                if (blockstate.canSustainPlant(blockGetter, blockpos.m_7918_(i, 0, j), Direction.UP, (IPlantable)block)) {
                    speedBoost = 1.0f;
                    if (blockstate.isFertile(blockGetter, pos.m_7918_(i, 0, j))) {
                        speedBoost = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    speedBoost /= 4.0f;
                }
                speed += speedBoost;
            }
        }
        BlockPos north = pos.m_122012_();
        BlockPos south = pos.m_122019_();
        BlockPos west = pos.m_122024_();
        BlockPos east = pos.m_122029_();
        boolean matchesEastWestRow = blockGetter.m_8055_(west).m_60713_(block) || blockGetter.m_8055_(east).m_60713_(block);
        boolean bl = matchesNorthSouthRow = blockGetter.m_8055_(north).m_60713_(block) || blockGetter.m_8055_(south).m_60713_(block);
        if (matchesEastWestRow && matchesNorthSouthRow) {
            speed /= 2.0f;
        } else {
            boolean matchesDiagonalRows;
            boolean bl2 = matchesDiagonalRows = blockGetter.m_8055_(west.m_122012_()).m_60713_(block) || blockGetter.m_8055_(east.m_122012_()).m_60713_(block) || blockGetter.m_8055_(east.m_122019_()).m_60713_(block) || blockGetter.m_8055_(west.m_122019_()).m_60713_(block);
            if (matchesDiagonalRows) {
                speed /= 2.0f;
            }
        }
        return speed /= 2.5f;
    }

    protected boolean m_6266_(BlockState blockState, BlockGetter block, BlockPos pos) {
        return blockState.m_60713_((Block)VDBlocks.CURSED_FARMLAND.get()) || blockState.m_60713_((Block)VDBlocks.BLOODY_SOIL_FARMLAND.get());
    }

    @NotNull
    protected ItemLike m_6404_() {
        return (ItemLike)VDItems.ORCHID_SEEDS.get();
    }

    @NotNull
    public IntegerProperty m_7959_() {
        return AGE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateDefinition) {
        stateDefinition.m_61104_(new Property[]{AGE});
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return VDHelper.CURSED_PLANT_TYPE;
    }

    protected int m_7125_(Level worldIn) {
        return 1;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[this.m_52305_(blockState)];
    }
}

