/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.block;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.blocks.CursedEarthBlock;
import de.teamlapen.vampirism.blocks.VampirismFlowerBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.HolyWaterBottleItem;
import net.grid.vampiresdelight.common.registry.VDBlocks;
import net.grid.vampiresdelight.common.utility.VDHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import org.jetbrains.annotations.NotNull;

public class CursedFarmlandBlock
extends FarmBlock {
    public CursedFarmlandBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static void turnToCursedEarth(BlockState blockState, Level worldIn, BlockPos pos) {
        worldIn.m_46597_(pos, CursedFarmlandBlock.m_49897_((BlockState)blockState, (BlockState)((CursedEarthBlock)ModBlocks.CURSED_EARTH.get()).m_49966_(), (LevelAccessor)worldIn, (BlockPos)pos));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState aboveState = level.m_8055_(pos.m_7494_());
        return super.m_7898_(state, level, pos) || aboveState.m_60734_() instanceof StemGrownBlock;
    }

    public boolean isFertile(BlockState state, BlockGetter world, BlockPos pos) {
        if (state.m_60713_((Block)VDBlocks.CURSED_FARMLAND.get())) {
            return (Integer)state.m_61143_((Property)f_53243_) > 0;
        }
        return false;
    }

    public void m_213898_(BlockState blockState, ServerLevel worldIn, BlockPos pos, RandomSource randomSource) {
        int i = (Integer)blockState.m_61143_((Property)f_53243_);
        if (!CursedFarmlandBlock.isNearWater((LevelReader)worldIn, pos) && !worldIn.m_46758_(pos.m_7494_())) {
            if (i > 0) {
                worldIn.m_7731_(pos, (BlockState)blockState.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!CursedFarmlandBlock.isUnderCrops((BlockGetter)worldIn, pos)) {
                CursedFarmlandBlock.turnToCursedEarth(blockState, (Level)worldIn, pos);
            }
        } else if (i < 7) {
            worldIn.m_7731_(pos, (BlockState)blockState.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    private static boolean isUnderCrops(BlockGetter blockGetter, BlockPos pos) {
        BlockState plant = blockGetter.m_8055_(pos.m_7494_());
        BlockState state = blockGetter.m_8055_(pos);
        return plant.m_60734_() instanceof IPlantable && state.canSustainPlant(blockGetter, pos, Direction.UP, (IPlantable)plant.m_60734_());
    }

    private static boolean isNearWater(LevelReader levelReader, BlockPos pos) {
        BlockState state = levelReader.m_8055_(pos);
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-4, 0, -4), (BlockPos)pos.m_7918_(4, 1, 4))) {
            if (!state.canBeHydrated((BlockGetter)levelReader, pos, levelReader.m_6425_(blockpos), blockpos)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)levelReader, (BlockPos)pos);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            CursedFarmlandBlock.turnToCursedEarth(state, (Level)level, pos);
        }
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult hit) {
        ItemStack heldItemStack = player.m_21120_(handIn);
        Item heldItem = heldItemStack.m_41720_();
        if (heldItem instanceof HolyWaterBottleItem) {
            int uses;
            int n = heldItem == ModItems.HOLY_WATER_BOTTLE_ULTIMATE.get() ? 100 : (uses = heldItem == ModItems.HOLY_WATER_BOTTLE_ENHANCED.get() ? 50 : 25);
            if (player.m_217043_().m_188503_(uses) == 0) {
                heldItemStack.m_41764_(heldItemStack.m_41613_() - 1);
            }
            worldIn.m_46597_(pos, Blocks.f_50093_.m_49966_());
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType plantType = plantable.getPlantType(world, pos.m_121945_(facing));
        BlockState block = plantable.getPlant(world, pos);
        return plantable instanceof BushBlock && plantType != PlantType.CROP || plantType == VReference.VAMPIRE_PLANT_TYPE || plantType == VDHelper.CURSED_PLANT_TYPE || block.m_60734_() instanceof VampirismFlowerBlock;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return !this.m_49966_().m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) ? ((CursedEarthBlock)ModBlocks.CURSED_EARTH.get()).m_49966_() : super.m_5573_(context);
    }

    public void m_142072_(Level worldIn, @NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull Entity entity, float damage) {
        if (!worldIn.f_46443_ && ForgeHooks.onFarmlandTrample((Level)worldIn, (BlockPos)pos, (BlockState)((CursedEarthBlock)ModBlocks.CURSED_EARTH.get()).m_49966_(), (float)damage, (Entity)entity)) {
            CursedFarmlandBlock.turnToCursedEarth(blockState, worldIn, pos);
        }
        entity.m_142535_(damage, 1.0f, entity.m_269291_().m_268989_());
    }
}

