/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.block;

import de.teamlapen.vampirism.sit.SitEntity;
import de.teamlapen.vampirism.sit.SitUtil;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BarStoolBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public BarStoolBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_278183_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockState blockAbove = pLevel.m_8055_(pPos.m_7494_());
        if (BarStoolBlock.isClickedOnSeat(pPos, pHit) && (blockAbove.m_60795_() || blockAbove.m_204336_(BlockTags.f_13093_) || blockAbove.m_204336_(BlockTags.f_13036_) || blockAbove.m_60713_(Blocks.f_50489_))) {
            BarStoolBlock.startSitting(pPlayer, pLevel, pPos, 0.75);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    private static boolean isClickedOnSeat(BlockPos pPos, BlockHitResult pHit) {
        return pHit.m_82450_().m_7098_() >= (double)pPos.m_123342_() + 0.8125;
    }

    public static void startSitting(@NotNull Player pPlayer, @NotNull Level pLevel, @NotNull BlockPos pPos, double offset) {
        SitEntity sit;
        if (!pLevel.f_46443_ && !SitUtil.isPlayerSitting((Player)pPlayer) && !pPlayer.m_6144_() && BarStoolBlock.isPlayerInRange(pPlayer, pPos) && !SitUtil.isOccupied((Level)pLevel, (BlockPos)pPos) && SitUtil.addSitEntity((Level)pLevel, (BlockPos)pPos, (SitEntity)(sit = SitEntity.newEntity((Level)pLevel, (BlockPos)pPos, (double)offset, (Vec3)pPlayer.m_20182_())))) {
            pLevel.m_7967_((Entity)sit);
            pPlayer.m_20329_((Entity)sit);
        }
    }

    private static boolean isPlayerInRange(@NotNull Player pPlayer, BlockPos pPos) {
        Vec3 playerPos = pPlayer.m_20182_();
        Vec3 blockPos = new Vec3((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_());
        AttributeInstance blockReach = pPlayer.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get());
        double blockReachDistance = blockReach == null ? 4.5 : blockReach.m_22135_();
        blockPos = blockPos.m_82520_(0.5, 0.5, 0.5);
        AABB range = new AABB(blockPos.m_7096_() + blockReachDistance, blockPos.m_7098_() + blockReachDistance, blockPos.m_7094_() + blockReachDistance, blockPos.m_7096_() - blockReachDistance, blockPos.m_7098_() - blockReachDistance, blockPos.m_7094_() - blockReachDistance);
        playerPos = playerPos.m_82520_(0.5, 0.5, 0.5);
        return range.f_82288_ <= playerPos.m_7096_() && range.f_82289_ <= playerPos.m_7098_() && range.f_82290_ <= playerPos.m_7094_() && range.f_82291_ >= playerPos.m_7096_() && range.f_82292_ >= playerPos.m_7098_() && range.f_82293_ >= playerPos.m_7094_();
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
        SitEntity entity = SitUtil.getSitEntity((Level)pLevel, (BlockPos)pPos);
        if (entity != null) {
            entity.m_146870_();
        }
    }

    public void m_5548_(BlockGetter pLevel, Entity pEntity) {
        if (pEntity.m_20162_()) {
            super.m_5548_(pLevel, pEntity);
        } else {
            Vec3 vec3 = pEntity.m_20184_();
            if (vec3.f_82480_ < 0.0) {
                double d0 = pEntity instanceof LivingEntity ? 1.0 : 0.8;
                pEntity.m_20334_(vec3.f_82479_, -vec3.f_82480_ * (double)0.66f * d0, vec3.f_82481_);
            }
        }
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        return SitUtil.isOccupied((Level)pLevel, (BlockPos)pPos) ? 15 : 0;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(pContext.m_43725_().m_6425_(pContext.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{WATERLOGGED});
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return BlockPathTypes.RAIL;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.m_83113_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0), (VoxelShape)Block.m_49796_((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (BooleanOp)BooleanOp.f_82695_);
    }

    public static Iterable<Block> getBarStoolBlocks() {
        return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> ForgeRegistries.BLOCKS.getKey(block) != null && "vampiresdelight".equals(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey(block)).m_135827_()) && block instanceof BarStoolBlock).collect(Collectors.toList());
    }
}

