/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common;

import net.grid.vampiresdelight.common.entity.AlchemicalCocktailEntity;
import net.grid.vampiresdelight.common.registry.VDAdvancementTriggers;
import net.grid.vampiresdelight.common.registry.VDItems;
import net.grid.vampiresdelight.common.registry.VDPotions;
import net.grid.vampiresdelight.common.registry.VDStats;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class CommonSetup {
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            VDPotions.registerPotionMixes();
            VDStats.registerModStats();
            CommonSetup.registerDispenserBehaviors();
            CommonSetup.registerCompostableItems();
        });
        CommonSetup.registerModIntegrations();
        VDAdvancementTriggers.register();
    }

    public static void registerDispenserBehaviors() {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)VDItems.ALCHEMICAL_COCKTAIL.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level pLevel, Position pPosition, ItemStack pStack) {
                return new AlchemicalCocktailEntity(pLevel, pPosition.m_7096_(), pPosition.m_7098_(), pPosition.m_7094_());
            }
        });
    }

    public static void registerCompostableItems() {
        ComposterBlock.f_51914_.put((Object)((ItemLike)VDItems.ORCHID_SEEDS.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)VDItems.ORCHID_PETALS.get()), 0.5f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)VDItems.WILD_GARLIC.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)VDItems.BLOOD_PIE_SLICE.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)VDItems.ORCHID_COOKIE.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)VDItems.BLOOD_PIE.get()), 1.0f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)VDItems.WEIRD_JELLY_BLOCK.get()), 1.0f);
    }

    public static void registerModIntegrations() {
    }
}

