/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.vampirism.api.entity.player.vampire.IBloodStats;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import java.util.Random;
import net.grid.vampiresdelight.common.mixin.accessor.BloodStatsAccessor;
import net.grid.vampiresdelight.common.utility.VDHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.GuiOverlayManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.registry.ModEffects;

public class NourishmentBloodOverlay {
    public static int bloodIconsOffset;
    private static final ResourceLocation ICONS_TEXTURE;
    static final ResourceLocation BLOOD_BAR_ID;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new NourishmentBloodOverlay());
    }

    @SubscribeEvent
    public void onRenderGuiOverlayPost(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() == GuiOverlayManager.findOverlay((ResourceLocation)BLOOD_BAR_ID)) {
            boolean isMounted;
            Minecraft mc = Minecraft.m_91087_();
            ForgeGui gui = (ForgeGui)mc.f_91065_;
            boolean bl = isMounted = mc.f_91074_ != null && mc.f_91074_.m_20202_() instanceof LivingEntity;
            if (!isMounted && !mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements() && VDHelper.isVampire((Player)mc.f_91074_)) {
                NourishmentBloodOverlay.renderNourishmentOverlay(gui, event.getGuiGraphics());
            }
        }
    }

    public static void renderNourishmentOverlay(ForgeGui gui, GuiGraphics graphics) {
        if (!((Boolean)Configuration.NOURISHED_HUNGER_OVERLAY.get()).booleanValue()) {
            return;
        }
        bloodIconsOffset = gui.rightHeight;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        VampirePlayer.getOpt((Player)player).map(VampirePlayer::getBloodStats).ifPresent(arg_0 -> NourishmentBloodOverlay.lambda$renderNourishmentOverlay$0(minecraft, (Player)player, graphics, arg_0));
    }

    private static /* synthetic */ void lambda$renderNourishmentOverlay$0(Minecraft minecraft, Player player, GuiGraphics graphics, IBloodStats stats) {
        boolean isPlayerHealingWithSaturation;
        int top = minecraft.m_91268_().m_85446_() - bloodIconsOffset + 10;
        int left = minecraft.m_91268_().m_85445_() / 2 + 91;
        int blood = stats.getBloodLevel();
        int maxBlood = stats.getMaxBlood();
        int blood2 = blood - 20;
        int maxBlood2 = maxBlood - 20;
        float saturation = ((BloodStatsAccessor)stats).getBloodSaturation();
        boolean bl = isPlayerHealingWithSaturation = player.m_9236_().m_46469_().m_46207_(GameRules.f_46139_) && player.m_36325_() && blood >= 18;
        if (player.m_21124_((MobEffect)ModEffects.NOURISHMENT.get()) != null && !Float.isNaN(saturation)) {
            int ticks = minecraft.f_91065_.m_93079_();
            Random rand = new Random();
            rand.setSeed((long)ticks * 312871L);
            RenderSystem.enableBlend();
            for (int j = 0; j < 10; ++j) {
                int idx = j * 2 + 1;
                int x = left - j * 8 - 9;
                int y = top;
                if (saturation <= 0.0f && ticks % (blood * 3 + 1) == 0) {
                    y = top + (rand.nextInt(3) - 1);
                }
                int naturalHealingOffset = isPlayerHealingWithSaturation ? 18 : 0;
                graphics.m_280218_(ICONS_TEXTURE, x, y, 0, idx <= maxBlood2 ? 9 : 0, 9, 9);
                if (idx < blood) {
                    graphics.m_280218_(ICONS_TEXTURE, x, top, 9 + naturalHealingOffset, idx < blood2 ? 9 : 0, 9, 9);
                    if (idx != blood2) continue;
                    graphics.m_280218_(ICONS_TEXTURE, x, top, 18 + naturalHealingOffset, 9, 9, 9);
                    continue;
                }
                if (idx != blood) continue;
                graphics.m_280218_(ICONS_TEXTURE, x, top, 18 + naturalHealingOffset, 0, 9, 9);
            }
            RenderSystem.disableBlend();
        }
    }

    static {
        ICONS_TEXTURE = new ResourceLocation("vampiresdelight", "textures/gui/icons.png");
        BLOOD_BAR_ID = VDHelper.BLOOD_BAR_ELEMENT;
    }
}

