/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import com.google.common.collect.Lists;
import de.teamlapen.lib.lib.inventory.BooleanDataSlot;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.blocks.WeaponTableBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.inventory.WeaponTableCraftingSlot;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.recipebook.ServerPlaceRecipe;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.IContainerFactory;
import org.jetbrains.annotations.NotNull;

public class WeaponTableMenu
extends RecipeBookMenu<CraftingContainer> {
    private final ContainerLevelAccess worldPos;
    @NotNull
    private final HunterPlayer hunterPlayer;
    @NotNull
    private final Player player;
    private final CraftingContainer craftMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 4, 4);
    private final ResultContainer craftResult = new ResultContainer();
    private final BooleanDataSlot missingLava = new BooleanDataSlot();

    public WeaponTableMenu(int id, @NotNull Inventory playerInventory, ContainerLevelAccess worldPosCallable) {
        super((MenuType)ModContainer.WEAPON_TABLE.get(), id);
        this.worldPos = worldPosCallable;
        this.hunterPlayer = HunterPlayer.get(playerInventory.f_35978_);
        this.player = playerInventory.f_35978_;
        this.m_38897_(new WeaponTableCraftingSlot(playerInventory.f_35978_, this.craftMatrix, (Container)this.craftResult, 0, 144, 46, worldPosCallable));
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.m_38897_(new Slot((Container)this.craftMatrix, j + i * 4, 34 + j * 19, 16 + i * 19));
            }
        }
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.m_38897_(new Slot((Container)playerInventory, i1 + k * 9 + 9, 18 + i1 * 18, 107 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.m_38897_(new Slot((Container)playerInventory, l, 18 + l * 18, 165));
        }
        this.m_6199_((Container)this.craftMatrix);
        this.m_38895_(this.missingLava);
    }

    public boolean m_5882_(@NotNull ItemStack stack, @NotNull Slot slotIn) {
        return slotIn.f_40218_ != this.craftResult && super.m_5882_(stack, slotIn);
    }

    public void m_6650_() {
        this.craftMatrix.m_6211_();
        this.craftResult.m_6211_();
    }

    public void m_5816_(@NotNull StackedContents recipeItemHelper) {
        this.craftMatrix.m_5809_(recipeItemHelper);
    }

    public int m_6656_() {
        return this.craftMatrix.m_39346_();
    }

    public int m_6635_() {
        return this.craftMatrix.m_39347_();
    }

    @NotNull
    public RecipeBookType m_5867_() {
        return RecipeBookType.CRAFTING;
    }

    public boolean m_142157_(int p_150635_) {
        return p_150635_ != this.m_6636_();
    }

    public int m_6636_() {
        return 0;
    }

    public void m_6951_(boolean shouldPlaceAll, @NotNull Recipe<?> recipe, @NotNull ServerPlayer serverPlayer) {
        new NBTServerPlaceRecipe<CraftingContainer>(this).m_135434_(serverPlayer, recipe, shouldPlaceAll);
    }

    @NotNull
    public List<RecipeBookCategories> getRecipeBookCategories() {
        return Lists.newArrayList((Object[])new RecipeBookCategories[]{RecipeBookCategories.UNKNOWN});
    }

    public int m_6653_() {
        return 17;
    }

    public boolean hasLava() {
        return (Boolean)this.worldPos.m_39299_((world, blockPos) -> (Integer)world.m_8055_(blockPos).m_61143_((Property)WeaponTableBlock.LAVA) > 0, (Object)false);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player playerIn, int index) {
        ItemStack itemStackCopy = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemStackCopy = itemstack1.m_41777_();
            if (index == 0) {
                if (!this.m_38903_(itemstack1, 17, 53, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemStackCopy);
            } else if (index >= 17 && index < 44 ? !this.m_38903_(itemstack1, 44, 53, false) : (index >= 44 && index < 53 ? !this.m_38903_(itemstack1, 17, 44, false) : !this.m_38903_(itemstack1, 17, 53, false))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemStackCopy.m_41613_() == itemstack1.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemStackCopy;
    }

    public boolean isMissingLava() {
        return this.missingLava.getB();
    }

    public boolean m_6032_(@NotNull Recipe<? super CraftingContainer> recipeIn) {
        return recipeIn.m_5818_((Container)this.craftMatrix, this.player.m_9236_());
    }

    public void m_6877_(@NotNull Player playerIn) {
        super.m_6877_(playerIn);
        this.worldPos.m_39292_((world, pos) -> {
            this.m_150411_(playerIn, (Container)this.craftMatrix);
            for (int i = 0; i < this.craftMatrix.m_6643_(); ++i) {
                ItemStack itemstack = this.craftMatrix.m_8016_(i);
                if (itemstack.m_41619_()) continue;
                playerIn.m_36176_(itemstack, false);
            }
            this.missingLava.set(false);
        });
    }

    public void m_6199_(@NotNull Container inventoryIn) {
        this.worldPos.m_39292_((world, pos) -> this.slotChangedCraftingGrid((Level)world, this.player, this.hunterPlayer, this.craftMatrix, this.craftResult));
    }

    public boolean m_6875_(@NotNull Player playerIn) {
        return WeaponTableMenu.m_38889_((ContainerLevelAccess)this.worldPos, (Player)playerIn, (Block)((Block)ModBlocks.WEAPON_TABLE.get()));
    }

    private void slotChangedCraftingGrid(@NotNull Level worldIn, Player playerIn, @NotNull HunterPlayer hunter, @NotNull CraftingContainer craftMatrixIn, @NotNull ResultContainer craftResultIn) {
        if (!worldIn.f_46443_ && playerIn instanceof ServerPlayer) {
            IWeaponTableRecipe recipe;
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            Optional optional = worldIn.m_7654_() == null ? Optional.empty() : worldIn.m_7654_().m_129894_().m_44015_((RecipeType)ModRecipes.WEAPONTABLE_CRAFTING_TYPE.get(), (Container)craftMatrixIn, worldIn);
            this.missingLava.set(false);
            craftResultIn.m_6836_(0, ItemStack.f_41583_);
            if (optional.isPresent() && (craftResultIn.m_40135_(worldIn, serverPlayer, (Recipe)(recipe = (IWeaponTableRecipe)optional.get())) || ModList.get().isLoaded("fastbench")) && recipe.getRequiredLevel() <= hunter.getLevel() && Helper.areSkillsEnabled(hunter.getSkillHandler(), recipe.getRequiredSkills())) {
                this.worldPos.m_39292_((world, pos) -> {
                    if ((Integer)world.m_8055_(pos).m_61143_((Property)WeaponTableBlock.LAVA) >= recipe.getRequiredLavaUnits()) {
                        craftResultIn.m_6836_(0, recipe.assemble(craftMatrixIn, world.m_9598_()));
                    } else {
                        this.missingLava.set(true);
                    }
                });
            }
            this.m_38946_();
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, this.m_182425_(), 0, craftResultIn.m_8020_(0)));
        }
    }

    static class NBTServerPlaceRecipe<C extends Container>
    extends ServerPlaceRecipe<C> {
        public NBTServerPlaceRecipe(@NotNull RecipeBookMenu<C> p_135431_) {
            super(p_135431_);
        }

        protected void m_135438_(Slot p_135439_, ItemStack p_135440_) {
            ItemStack itemstack;
            int i = this.findSlotMatchingUnusedItem(p_135440_);
            if (i != -1 && !(itemstack = this.f_135427_.m_8020_(i).m_41777_()).m_41619_()) {
                if (itemstack.m_41613_() > 1) {
                    this.f_135427_.m_7407_(i, 1);
                } else {
                    this.f_135427_.m_8016_(i);
                }
                itemstack.m_41764_(1);
                if (p_135439_.m_7993_().m_41619_()) {
                    p_135439_.m_5852_(itemstack);
                } else {
                    p_135439_.m_7993_().m_41769_(1);
                }
            }
        }

        public int findSlotMatchingUnusedItem(@NotNull ItemStack p_36044_) {
            for (int i = 0; i < this.f_135427_.f_35974_.size(); ++i) {
                ItemStack itemstack = (ItemStack)this.f_135427_.f_35974_.get(i);
                if (((ItemStack)this.f_135427_.f_35974_.get(i)).m_41619_() || !p_36044_.m_150930_(itemstack.m_41720_()) || ((ItemStack)this.f_135427_.f_35974_.get(i)).m_41768_() || itemstack.m_41793_() || itemstack.m_41788_()) continue;
                return i;
            }
            return -1;
        }
    }

    public static class Factory
    implements IContainerFactory<WeaponTableMenu> {
        @NotNull
        public WeaponTableMenu create(int windowId, @NotNull Inventory inv, @NotNull FriendlyByteBuf data) {
            BlockPos pos = data.m_130135_();
            return new WeaponTableMenu(windowId, inv, ContainerLevelAccess.m_39289_((Level)inv.f_35978_.m_9236_(), (BlockPos)pos));
        }
    }
}

