/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.skills;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillType;
import de.teamlapen.vampirism.entity.player.skills.SkillManager;
import de.teamlapen.vampirism.entity.player.skills.SkillNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkillTree {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ResourceLocation, SkillNode> rootNodes = new HashMap<ResourceLocation, SkillNode>();
    private final Map<ResourceLocation, Integer[]> skillNodeSizeMap = new HashMap<ResourceLocation, Integer[]>();
    @NotNull
    private Map<ResourceLocation, SkillNode> allNodes = new HashMap<ResourceLocation, SkillNode>();

    @NotNull
    public Map<ResourceLocation, SkillNode.Builder> getCopy() {
        HashMap<ResourceLocation, SkillNode.Builder> map = new HashMap<ResourceLocation, SkillNode.Builder>();
        for (SkillNode root : this.rootNodes.values()) {
            this.addChildrenCopyToMap(root, map);
        }
        return map;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Integer[] getDisplayInfo(ResourceLocation faction) {
        if (!this.skillNodeSizeMap.containsKey(faction)) {
            this.skillNodeSizeMap.put(faction, this.createDisplayInfo(this.getRootNodeForFaction(faction)));
        }
        return this.skillNodeSizeMap.get(faction);
    }

    @Nullable
    public SkillNode getNodeFromId(ResourceLocation id) {
        return this.allNodes.get(id);
    }

    @NotNull
    public SkillNode getRootNodeForFaction(ResourceLocation id) {
        if (!this.rootNodes.containsKey(id)) {
            throw new IllegalStateException("Faction " + id + " does not have a root skill");
        }
        return this.rootNodes.get(id);
    }

    @NotNull
    public SkillNode getRootNodeForFaction(@NotNull ResourceLocation id, @NotNull ISkillType type) {
        ResourceLocation skillId = type.createIdForFaction(id);
        if (!this.rootNodes.containsKey(skillId)) {
            throw new IllegalStateException("Faction " + skillId + " does not have a root skill");
        }
        return this.rootNodes.get(skillId);
    }

    public static int getTreeWidth(@NotNull SkillNode node) {
        int max = node.getElements().length * 26 + (node.getElements().length - 1) * 10;
        int children = node.getChildren().size() > 0 ? (node.getChildren().size() - 1) * 30 : 0;
        for (SkillNode child : node.getChildren()) {
            children += SkillTree.getTreeWidth(child);
        }
        return Math.max(max, children);
    }

    public static int getTreeHeight(@NotNull SkillNode node) {
        int max = 0;
        for (SkillNode child : node.getChildren()) {
            max = Math.max(max, SkillTree.getTreeHeight(child) + 50);
        }
        return max;
    }

    public void initRootSkills() {
        this.rootNodes.clear();
        for (IPlayableFaction<?> faction : VampirismAPI.factionRegistry().getPlayableFactions()) {
            for (ISkillType value : VampirismAPI.skillManager().getSkillTypes()) {
                if (!value.isForFaction(faction)) continue;
                SkillNode rootNode = new SkillNode(faction, ((SkillManager)VampirismAPI.skillManager()).getRootSkill(faction, value), value);
                this.rootNodes.put(rootNode.getId(), rootNode);
            }
        }
    }

    public void loadNodes(@NotNull Map<ResourceLocation, SkillNode.Builder> nodes) {
        HashMap<ResourceLocation, SkillNode> builtNodes = new HashMap<ResourceLocation, SkillNode>();
        this.rootNodes.clear();
        for (IPlayableFaction<?> faction : VampirismAPI.factionRegistry().getPlayableFactions()) {
            for (ISkillType value : VampirismAPI.skillManager().getSkillTypes()) {
                if (!value.isForFaction(faction)) continue;
                SkillNode rootNode = new SkillNode(faction, ((SkillManager)VampirismAPI.skillManager()).getRootSkill(faction, value), value);
                builtNodes.put(rootNode.getId(), rootNode);
                this.rootNodes.put(rootNode.getId(), rootNode);
            }
        }
        Iterator<Map.Entry<ResourceLocation, SkillNode.Builder>> it = nodes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ResourceLocation, SkillNode.Builder> entry = it.next();
            SkillNode.Builder builder = entry.getValue();
            if (builder.mergeId == null) continue;
            SkillNode.Builder b = nodes.get(builder.mergeId);
            if (b == null) {
                LOGGER.error("Could not load skill node {} because merge target {} couldn't be found", (Object)entry.getKey(), (Object)builder.mergeId);
            } else {
                b.skills.addAll(builder.skills);
            }
            it.remove();
        }
        while (!nodes.isEmpty()) {
            boolean flag = false;
            Iterator<Map.Entry<ResourceLocation, SkillNode.Builder>> iterator = nodes.entrySet().iterator();
            while (iterator.hasNext()) {
                SkillNode parent;
                Map.Entry<ResourceLocation, SkillNode.Builder> entry = iterator.next();
                ResourceLocation id = entry.getKey();
                SkillNode.Builder builder = entry.getValue();
                if (builder.parentId == null || (parent = (SkillNode)builtNodes.get(builder.parentId)) == null) continue;
                if (!builder.checkSkillFaction(parent.getFaction())) {
                    LOGGER.error("Cannot create skill node {} because skills do not match the derived faction {}", (Object)id, parent.getFaction());
                } else {
                    builtNodes.put(id, builder.build(id, parent));
                }
                iterator.remove();
                flag = true;
            }
            if (flag) continue;
            for (Map.Entry<ResourceLocation, SkillNode.Builder> entry : nodes.entrySet()) {
                LOGGER.error("Could not load skill node (probably parent invalid) {}: {}", (Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        this.allNodes = builtNodes;
        LOGGER.info("Loaded {} skill nodes", (Object)(builtNodes.size() - this.rootNodes.size()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateRenderInfo() {
        for (SkillNode n : this.rootNodes.values()) {
            this.setRenderPos(n, 0);
        }
    }

    private void addChildrenCopyToMap(@NotNull SkillNode n, @NotNull Map<ResourceLocation, SkillNode.Builder> map) {
        for (SkillNode c : n.getChildren()) {
            map.put(c.getId(), c.getCopy());
            this.addChildrenCopyToMap(c, map);
        }
    }

    private int calculateEndPoints(@NotNull SkillNode start) {
        if (start.getChildren().size() == 0) {
            return 1;
        }
        int count = 0;
        for (SkillNode node : start.getChildren()) {
            count += this.calculateEndPoints(node);
        }
        return count;
    }

    private int calculateMaxSkillDepth(@NotNull SkillNode start) {
        int max = start.getDepth();
        for (SkillNode node : start.getChildren()) {
            int n = this.calculateMaxSkillDepth(node);
            if (n <= max) continue;
            max = n;
        }
        return max;
    }

    private int calculateMaxSkillsPerNode(@NotNull SkillNode start) {
        int max = start.getElements().length;
        for (SkillNode node : start.getChildren()) {
            int n = this.calculateMaxSkillsPerNode(node);
            if (n <= max) continue;
            max = n;
        }
        return max;
    }

    private Integer @NotNull [] createDisplayInfo(@NotNull SkillNode root) {
        Integer[] info = new Integer[]{this.calculateEndPoints(root), this.calculateMaxSkillsPerNode(root), this.calculateMaxSkillDepth(root) + 1};
        return info;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setRenderPos(@NotNull SkillNode base, int column) {
        int i;
        int left = -(base.getElements().length * 2 - 1) / 2;
        for (ISkill<?> skill : base.getElements()) {
            skill.setRenderPos(base.getDepth() * 2, column + left);
            left += 2;
        }
        int[] widths = new int[base.getChildren().size()];
        int total = 0;
        for (i = 0; i < widths.length; ++i) {
            SkillNode node = base.getChildren().get(i);
            widths[i] = this.calculateMaxSkillsPerNode(node) * this.calculateEndPoints(node) * 2;
            total += widths[i];
        }
        left = -total / 2;
        for (i = 0; i < widths.length; ++i) {
            this.setRenderPos(base.getChildren().get(i), column + left + widths[i] / 2);
            left += widths[i];
        }
    }
}

